<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package hostom
 */
?>

<?php

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="blog-details blog-details__content">
		<div class="blog-card__two ">
			<?php if ( has_post_thumbnail() ) : ?>
				<div class="blog-card__two__image blog-card__two__image--two">
					<?php the_post_thumbnail( 'hostom_blog_770X450' ); ?>
					<div class="blog-card__two__date">
						<?php echo wp_kses( hostom_get_blog_date(), 'hostom_allowed_tags' ); ?>
					</div>
					<!-- /.blog-card__two__date -->
				</div><!-- /.blog-card__two__image -->
			<?php endif; ?>
			<div class=" blog-card-two__content clearfix">
				<ul class="list-unstyled blog-card__two__meta ml-0">
					<li class="blog-card__two__meta__item">
						<?php hostom_posted_by(); ?>
					</li>
					<?php if ( ! empty( get_comments_number() ) ) : ?>
						<li class="blog-card__two__meta__item">
							<?php hostom_comment_count(); ?>
						</li>
					<?php endif; ?>
				</ul><!-- /.list-unstyled blog-card__two__meta -->
				<?php
				the_content(
					sprintf(
						wp_kses(
							/* translators: %s: Name of current post. Only visible to screen readers */
							__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'hostom' ),
							array(
								'span' => array(
									'class' => array(),
								),
							)
						),
						wp_kses_post( get_the_title() )
					)
				);

				wp_link_pages(
					array(
						'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'hostom' ),
						'after' => '</div>',
					)
				);
				?>
			</div><!-- /.blog-card-two__content -->
		</div><!-- /.blog-card -->

		<div class="blog-details__meta">
			<?php hostom_entry_footer(); ?>
		</div><!-- /.blog-details__meta -->
	</div><!-- /.blog-details -->

</article><!-- #post-<?php the_ID(); ?> -->