<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package hostom
 */

get_header();


?>

<?php if ('yes' == get_theme_mod('error_custom')) : ?>
    <?php echo do_shortcode(\Elementor\Plugin::$instance->frontend->get_builder_content(get_theme_mod('error_custom_post'))); ?>
<?php else : ?>
    <main id="primary" class="site-main">
        <section class="error-404">
            <div class="container">
                <h1 class="error-page__404-title"><?php echo esc_html__('404', 'hostom'); ?></h1>
                <h3 class="error-404__sub-title  wow fadeInUp" data-wow-duration="1500ms"><?php esc_html_e('Oops! Page Not Found', 'hostom'); ?></h3><!-- /.error-404__title -->
                <p class="error-404__text  wow fadeInUp" data-wow-duration="1500ms"><?php esc_html_e('The page you are looking for is not exist.', 'hostom'); ?></p><!-- /.error-404__text -->
                <form method="get" class="error-404__search">
                    <input type="text" id="error-search" placeholder="<?php esc_attr_e('Search Here', 'hostom'); ?>">
                    <button type="submit" class="error-404__search__btn">
                        <span><i class="icon-search"></i></span>
                    </button>
                </form><!-- /.error-404__search -->
                <div class="error-404__btns">
                    <a href="<?php echo esc_url(home_url('/')); ?>" class="hostom-btn hostom-btn--secondary"><span><?php esc_html_e('Back to Home ', 'hostom'); ?></span></a>
                </div><!-- /.error-404__btns -->
            </div><!-- /.container -->
        </section><!-- /.error-404 -->
    </main><!-- #main -->
<?php endif; ?>

<?php
get_footer();
