<?php

// Arguments for querying comments
$comment_args = array(
    'post_type' => 'post', // Specify the custom post type
    'number'    => $comment_count, // Number of comments to display
    'status'    => 'approve', // Only approved comments
    'order'     => 'DESC', // Order by most recent
);

// Get comments
$comments = get_comments($comment_args);
?>

<ul class="sidebar__comments list-unstyled">
    <?php foreach ($comments as $comment) {
        $comment_post = get_post($comment->comment_post_ID);
        $author_name = get_comment_author($comment->comment_ID); // Get author name
        $post_title = get_the_title($comment_post); // Get post title
        $comment_link = get_permalink($comment_post) . '#comment-' . $comment->comment_ID; // Construct comment permalink

    ?>
        <li class="sidebar__comments__item">
            <div class="sidebar__comments__icon">
                <i class="icon-massage"></i>
            </div><!-- /.sidebar__comments__icon -->
            <h6 class="sidebar__comments__title">
                <a href="<?php echo esc_url($comment_link); ?>"><?php echo esc_html($author_name); ?><?php echo esc_html_e(' on ', 'hostom-addon'); ?><?php echo get_the_title($comment_post); ?></a>
            </h6><!-- /.sidebar__comments__title -->
        </li>
    <?php }
    ?>
</ul><!-- /.sidebar__comments list-unstyled -->