<?php

namespace Layerdrops\Hostom\Widgets;


class Video extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-video';
    }

    public function get_title()
    {
        return __('Video', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                    // 'layout_three' => __('Layout Three', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include hostom_get_elementor_option('video-one-option.php');
        include hostom_get_elementor_option('video-two-option.php');
        // include hostom_get_elementor_option('video-three-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        hostom_elementor_general_style_options($this, 'Video Title', '{{WRAPPER}} .video-one__title,{{WRAPPER}} .video-two__title', ['layout_one', 'layout_two']);
        hostom_elementor_general_style_options($this, 'Video Rounded Text', '{{WRAPPER}} .curved-circle--item,{{WRAPPER}} .video-two__btn .curved-circle--item span', ['layout_one', 'layout_two']);

        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .video-one__link::before,{{WRAPPER}} .hostom-btn::before', '{{WRAPPER}} .hostom-btn::after', ['layout_one', 'layout_two']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('video-one.php');
        include hostom_get_template('video-two.php');
        // include hostom_get_template('video-three.php');
    }
}
