<?php

namespace Layerdrops\Hostom\Widgets;


class Testimonials extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-testimonials';
    }

    public function get_title()
    {
        return __('Testimonials', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {


        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                    'layout_three' => __('Layout Three', 'hostom-addon'),
                    'layout_four' => __('Layout Four', 'hostom-addon'),
                    'layout_five' => __('Layout Five', 'hostom-addon'),
                    'layout_six' => __('Layout Six', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include hostom_get_elementor_option('testimonial-one-option.php');
        include hostom_get_elementor_option('testimonial-two-option.php');
        include hostom_get_elementor_option('testimonial-three-option.php');
        include hostom_get_elementor_option('testimonial-four-option.php');
        include hostom_get_elementor_option('testimonial-five-option.php');
        include hostom_get_elementor_option('testimonial-six-option.php');


        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .sec-title__title', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        hostom_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .sec-title__tagline', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        hostom_elementor_general_style_options($this, 'Section Summary', '{{WRAPPER}} .testimonials-three__text', ['layout_two']);

        hostom_elementor_general_style_options($this, 'Name', '{{WRAPPER}} .testimonial-two__thumb__name,{{WRAPPER}} .testimonials-three__card__author__content__name,{{WRAPPER}} .testimonial-three__author__name,{{WRAPPER}} .testimonial-fore__item__author__name', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        hostom_elementor_general_style_options($this, 'Designation', '{{WRAPPER}} .testimonial-two__thumb__deg,{{WRAPPER}} .testimonials-three__card__author__content__deg,{{WRAPPER}} .testimonial-three__author__deg,{{WRAPPER}} .testimonial-fore__item__author__deg', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        hostom_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .testimonial-two__title, {{WRAPPER}} .testimonials-three__card__title,{{WRAPPER}} .testimonial-fore__item__title', ['layout_one', 'layout_two', 'layout_four']);
        hostom_elementor_general_style_options($this, 'Testimonial', '{{WRAPPER}} .testimonial-two__text, {{WRAPPER}} .testimonials-three__card__text,{{WRAPPER}} .testimonial-three__text, {{WRAPPER}} .testimonial-fore__item__text', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        hostom_elementor_general_style_options($this, 'Rating Icon', '{{WRAPPER}} .testimonial-two__rating,{{WRAPPER}} .testimonials-three__card__rating,{{WRAPPER}} .testimonial-three__rating,{{WRAPPER}} .testimonial-fore__item__rating', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);

        $this->end_controls_section();

        hostom_get_elementor_carousel_options($this, ['layout_two']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('testimonials-one.php');
        include hostom_get_template('testimonials-two.php');
        include hostom_get_template('testimonials-three.php');
        include hostom_get_template('testimonials-four.php');
        // include hostom_get_template('testimonials-five.php');
        // include hostom_get_template('testimonials-six.php');
    }
}
