<?php

namespace Layerdrops\Hostom\Widgets;


class Team extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-team';
    }

    public function get_title()
    {
        return __('Team', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                    'layout_three' => __('Layout Three', 'hostom-addon'),
                    'layout_four' => __('Layout Four', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include hostom_get_elementor_option('team-one-option.php');
        include hostom_get_elementor_option('team-two-option.php');
        include hostom_get_elementor_option('team-three-option.php');
        // include hostom_get_elementor_option('team-four-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .team-details__content__title', ['layout_three']);
        hostom_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .team-details__content__subtitle', ['layout_three']);
        hostom_elementor_general_style_options($this, 'Summary Text', '{{WRAPPER}} .team-details__content__text', ['layout_three']);
        hostom_elementor_general_style_options($this, 'Highlighted Text', '{{WRAPPER}} .team-details__content__highlight__text', ['layout_three']);
        hostom_elementor_general_style_options($this, 'Progressbar Title', '{{WRAPPER}} .team-details .team-skills__progress__title', ['layout_three']);

        hostom_elementor_general_style_options($this, 'Name', '{{WRAPPER}} .team-card__content__title a', ['layout_one', 'layout_two']);
        hostom_elementor_general_style_options($this, 'Designation', '{{WRAPPER}} .team-card__content__designation', ['layout_one', 'layout_two']);


        // hostom_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .team-details__title', ['layout_three']);
        // hostom_elementor_general_style_options($this, 'Summary', '{{WRAPPER}} .team-details__text', ['layout_three']);
        // hostom_elementor_general_style_options($this, 'Features Title', '{{WRAPPER}} .team-details__highlight', ['layout_three']);
        // hostom_elementor_general_style_options($this, 'Features List', '{{WRAPPER}} .team-details__list li', ['layout_three']);
        // hostom_elementor_general_style_options($this, 'Progressbar Title', '{{WRAPPER}} .team-skills-one__progress__title', ['layout_three']);
        // hostom_elementor_general_style_options($this, 'Progressbar Count', '{{WRAPPER}} .team-skills-one__progress__number', ['layout_three']);
        // hostom_elementor_general_style_options($this, 'Image Title', '{{WRAPPER}} .team-details__icon__text', ['layout_three']);

        $this->end_controls_section();

        hostom_elementor_column_count_options($this, ['layout_one']);

        hostom_get_elementor_carousel_options($this, ['layout_two', 'layout_four']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('team-one.php');
        include hostom_get_template('team-two.php');
        include hostom_get_template('team-three.php');
        // include hostom_get_template('team-four.php');
    }
}
