<?php

namespace Layerdrops\Hostom\Widgets;


class Tab extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'hostom-tab';
	}

	public function get_title()
	{
		return __('Tab', 'hostom-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['hostom-category'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'hostom-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'hostom-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'hostom-addon'),
					'layout_two' => __('Layout Two', 'hostom-addon'),
					'layout_three' => __('Layout Three', 'hostom-addon'),
				]
			]
		);

		$this->end_controls_section();

		include hostom_get_elementor_option('tab-one-option.php');
		include hostom_get_elementor_option('tab-two-option.php');
		include hostom_get_elementor_option('tab-three-option.php');

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Content Style', 'hostom-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		hostom_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .sec-title .sec-title__title', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
		hostom_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .sec-title__tagline', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

		hostom_elementor_general_style_options($this, 'Tab Name', '{{WRAPPER}} .benefits-one__inner,{{WRAPPER}} .benefits-two__right__tab__link button,{{WRAPPER}} .benefits-fore__left__tab__link button', ['layout_one', 'layout_two', 'layout_three']);
		hostom_elementor_general_style_options($this, 'Active Tab Name', '{{WRAPPER}} .benefits-one__inner .active-btn, {{WRAPPER}} .benefits-two__right__tab__link button.active-btn,{{WRAPPER}} .benefits-fore__left__tab__link button.active-btn ', ['layout_one', 'layout_two', 'layout_three']);

		hostom_elementor_general_style_options($this, 'Title', '{{WRAPPER}}  .benefits-one__top .sec-title__title,{{WRAPPER}} .tabs-content .sec-title__title', ['layout_one', 'layout_three']);
		hostom_elementor_general_style_options($this, 'Summary', '{{WRAPPER}} .benefits-one__top__text,{{WRAPPER}} .benefits-two__text, {{WRAPPER}} .benefits-fore__text', ['layout_one', 'layout_two', 'layout_three']);
		hostom_elementor_general_style_options($this, 'Feature', '{{WRAPPER}} .benefits-one__list__item,{{WRAPPER}} .benefits-two__list__item,{{WRAPPER}} .benefits-fore__list__item', ['layout_one', 'layout_two', 'layout_three']);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include hostom_get_template('tab-one.php');
		include hostom_get_template('tab-two.php');
		include hostom_get_template('tab-three.php');
	}
}
