<?php

namespace Layerdrops\Hostom\Widgets;


class Subscribe extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'subscribe';
    }

    public function get_title()
    {
        return __('Subscribe', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include hostom_get_elementor_option('subscribe-one-option.php');
        include hostom_get_elementor_option('subscribe-two-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Title', '{{WRAPPER}}  .cta-two__inner__item__top__title,{{WRAPPER}} .cta-six__title', ['layout_one', 'layout_two']);
        hostom_elementor_general_style_options($this, 'Summary', '{{WRAPPER}}  .cta-two__inner__item__top__title,{{WRAPPER}} .cta-six__text', ['layout_two']);

        hostom_elementor_button_style_options($this, 'Button', '{{WRAPPER}} form button[type=submit]', '{{WRAPPER}} .hostom-btn--secondary::before', ['layout_one', 'layout_two']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('subscribe-one.php');
        include hostom_get_template('subscribe-two.php');
    }
}
