<?php

namespace Layerdrops\Hostom\Widgets;


class Sponsors extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-sponsors';
    }

    public function get_title()
    {
        return __('Sponsors', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                    'layout_three' => __('Layout Three', 'hostom-addon'),
                    // 'layout_four' => __('Layout Four', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'sec_title',
            [
                'label' => __('Section Title', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add title', 'hostom-addon'),
                'default' => __('Default Title', 'hostom-addon'),
                'condition' => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );


        $sponsor_images = new \Elementor\Repeater();

        $sponsor_images->add_control(
            'image',
            [
                'label' => __('Add Image', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'sponsor_images',
            [
                'label' => __('Sponsor Items', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $sponsor_images->get_controls(),
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .client-carousel__title', ['layout_one', 'layout_two', 'layout_three']);

        $this->end_controls_section();

        hostom_get_elementor_carousel_options($this, ['layout_one', 'layout_two', 'layout_three']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('sponsors-one.php');
        include hostom_get_template('sponsors-two.php');
        // include hostom_get_template('sponsors-three.php');
        // include hostom_get_template('sponsors-four.php');
    }
}
