<?php

namespace Layerdrops\Hostom\Widgets;


class SidebarNavmenu extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'sidebar-nav';
    }

    public function get_title()
    {
        return __('Sidebar Nav Menus', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    // 'layout_two' => __('Layout Two', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Widget Title', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('ALL SERVICES', 'hostom-addon'),
                'label_block' => true
            ]
        );

        hostom_elementor_heading_option($this, 'Widget Title', 'h3', 'layout_one');

        $sidebar_nav = new \Elementor\Repeater();

        $sidebar_nav->add_control(
            'name',
            [
                'label' => __('Title', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Citizenship Test', 'hostom-addon'),
                'label_block' => true,
            ]
        );

        $sidebar_nav->add_control(
            'url',
            [
                'label' => __(' Url', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'hostom-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_label' => false,
            ]
        );

        $sidebar_nav->add_control(
            'active_status',
            [
                'label' => __('Is active?', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'hostom-addon'),
                'label_off' => __('No', 'hostom-addon'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'sidebar_nav',
            [
                'label' => __('Sidebar Nav', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $sidebar_nav->get_controls(),
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .service-sidebar__title', ['layout_one']);
        hostom_elementor_general_style_options($this, 'Active Nav Menu', '{{WRAPPER}} .service-sidebar__nav li.current a', ['layout_one']);
        hostom_elementor_general_style_options($this, 'Nav Menu', '{{WRAPPER}} .service-sidebar__nav li a', ['layout_one']);


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('sidebar-nav-menu-one.php');
        // include hostom_get_template('sidebar-nav-menu-two.php');
    }
}
