<?php

namespace Layerdrops\Hostom\Widgets;


class SidebarDownload extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'sidebar-download';
    }

    public function get_title()
    {
        return __('Sidebar Download', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Project agreement form', 'hostom-addon'),
                'label_block' => true,
            ]
        );

        hostom_elementor_heading_option($this, 'Title', 'h3', 'layout_one');

        $this->add_control(
            'url',
            [
                'label' => __('File Url', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'hostom-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_label' => false,
            ]
        );

        $this->add_control(
            'file_size',
            [
                'label' => __('File Size', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('3.9KB', 'hostom-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => __('Icon', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'icon-pdf-file',
                    'library' => 'custom-icon',
                ],
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .services-details__document__title a', ['layout_one']);
        hostom_elementor_general_style_options($this, 'File Size', '{{WRAPPER}} .services-details__document__text', ['layout_one']);
        hostom_elementor_general_style_options($this, 'icon', '{{WRAPPER}} .services-details__document__icon span', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('sidebar-download-one.php');
    }
}
