<?php

namespace Layerdrops\Hostom\Widgets;


class SidebarCaseInfo extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'sidebar-case-info';
    }

    public function get_title()
    {
        return __('Portfolio Info', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $case_info = new \Elementor\Repeater();

        $case_info->add_control(
            'title',
            [
                'label' => __('Title', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Date:', 'hostom-addon'),
                'label_block' => true,
            ]
        );

        $case_info->add_control(
            'content',
            [
                'label' => __('Content', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('23 July 2023', 'hostom-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'case_info',
            [
                'label' => __('Portfolio Info', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'prevent_empty' => false,
                'fields' => $case_info->get_controls(),
            ]
        );

        $social_icons = new \Elementor\Repeater();

        $social_icons->add_control(
            'social_icon',
            [
                'label' => __('Select Icon', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'brand',
                ],
                'label_block' => true,
            ]
        );

        $social_icons->add_control(
            'social_url',
            [
                'label' => __('Add Url', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'hostom-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_label' => false,
            ]
        );

        $this->add_control(
            'social_icons',
            [
                'label' => __('Social Icons', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $social_icons->get_controls(),
                'prevent_empty' => false,
                'default' => [
                    [
                        'social_url' => [
                            'url' => '#',
                            'is_external' => false,
                            'nofollow' => false,
                        ],
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Portfolio Info Title', '{{WRAPPER}} .portfolio-details__info-list li span', ['layout_one']);
        hostom_elementor_general_style_options($this, 'Portfolio Info Content', '{{WRAPPER}} .portfolio-details__info-list li', ['layout_one']);

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'social_style',
            [
                'label' => esc_html__('Social Icon', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_button_style_options($this, 'Social Icon', '{{WRAPPER}} .portfolio-details__socials a', '{{WRAPPER}} .portfolio-details__socials a', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('sidebar-case-info-one.php');
    }
}
