<?php

namespace Layerdrops\Hostom\Widgets;


class Shop extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-shop';
    }

    public function get_title()
    {
        return __('Shop', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include  hostom_get_elementor_option('shop-option.php');


        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Product Title', '{{WRAPPER}} .product__item__title a', ['layout_one']);
        hostom_elementor_general_style_options($this, 'Product Price', '{{WRAPPER}} .product__item__price', ['layout_one']);

        $this->end_controls_section();

        //Button Style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .product__item .thm-btn', '{{WRAPPER}} .thm-btn::before', ['layout_one']);

        $this->end_controls_section();

        hostom_get_elementor_carousel_options($this, ['layout_one']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('shop-one.php');
        include hostom_get_template('shop-two.php');
    }
}
