<?php

namespace Layerdrops\Hostom\Widgets;


class Service extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-service';
    }

    public function get_title()
    {
        return __('Service', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                    'layout_three' => __('Layout Three', 'hostom-addon'),
                    'layout_four' => __('Layout Four', 'hostom-addon'),
                    'layout_five' => __('Layout Five', 'hostom-addon'),
                    'layout_six' => __('Layout Six', 'hostom-addon'),
                    'layout_seven' => __('Layout Seven', 'hostom-addon'),
                    'layout_eight' => __('Layout Eight', 'hostom-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        include hostom_get_elementor_option('service-one-option.php');
        include hostom_get_elementor_option('service-two-option.php');
        include hostom_get_elementor_option('service-three-option.php');
        include hostom_get_elementor_option('service-four-option.php');
        include hostom_get_elementor_option('service-five-option.php');
        include hostom_get_elementor_option('service-six-option.php');
        include hostom_get_elementor_option('service-seven-option.php');
        include hostom_get_elementor_option('service-eight-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        hostom_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .sec-title__title', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        hostom_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .sec-title__tagline', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        hostom_elementor_general_style_options($this, 'Section Summary', '{{WRAPPER}} .service-one__top__text', ['layout_one']);

        hostom_elementor_general_style_options($this, 'Service Title', '{{WRAPPER}} .service-one__card__title a, {{WRAPPER}} .service-two__item__title,{{WRAPPER}} .service-card-one__title a,{{WRAPPER}} .service-three__title a,{{WRAPPER}} .service-fore__inner__title a,{{WRAPPER}} .service-five__list__item__title a,{{WRAPPER}} .service-card-two__title a', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six', 'layout_seven', 'layout_eight']);
        hostom_elementor_general_style_options($this, 'Service Summary Text', '{{WRAPPER}} .service-one__card__text,{{WRAPPER}} .service-two__item__text,{{WRAPPER}} .service-card-one__text,{{WRAPPER}} .service-three__text,{{WRAPPER}} .service-fore__inner__text,{{WRAPPER}} .service-five__list__item__text,{{WRAPPER}} .service-card-two__text', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six', 'layout_seven', 'layout_eight']);

        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );

        hostom_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .service-one__btn a', '{{WRAPPER}} .service-one__btn a::before', ['layout_one']);

        $this->end_controls_section();

        hostom_get_elementor_carousel_options($this, ['layout_eight']);
        // hostom_elementor_column_count_options($this, ['layout_two']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('service-one.php');
        include hostom_get_template('service-two.php');
        include hostom_get_template('service-three.php');
        include hostom_get_template('service-four.php');
        include hostom_get_template('service-five.php');
        include hostom_get_template('service-six.php');
        include hostom_get_template('service-seven.php');
        include hostom_get_template('service-eight.php');
    }
}
