<?php

namespace Layerdrops\Hostom\Widgets;


class Pricing extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-pricing';
    }

    public function get_title()
    {
        return __('Pricing', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                    'layout_three' => __('Layout Three', 'hostom-addon'),
                    'layout_four' => __('Layout Four', 'hostom-addon'),
                    'layout_five' => __('Layout Five', 'hostom-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        include hostom_get_elementor_option('pricing-one-option.php');
        include hostom_get_elementor_option('pricing-two-option.php');
        include hostom_get_elementor_option('pricing-three-option.php');
        include hostom_get_elementor_option('pricing-four-option.php');
        include hostom_get_elementor_option('pricing-five-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .sec-title__title,{{WRAPPER}} .pricing-two__table__head__item .sec-title .title', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        hostom_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .sec-title__tagline,{{WRAPPER}} .pricing-two__table__head__item .sec-title .tagline', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

        hostom_elementor_general_style_options($this, 'Heading', '{{WRAPPER}} .price-page__inner__btn,{{WRAPPER}} .price-five__inner__btn', ['layout_one', 'layout_two', 'layout_four']);
        hostom_elementor_general_style_options($this, 'Active Heading', '{{WRAPPER}} .price-page__inner__btn.active-btn,{{WRAPPER}} .price-five__inner__btn.active-btn', ['layout_one', 'layout_two', 'layout_four']);

        hostom_elementor_general_style_options($this, 'Plan Title', '{{WRAPPER}} .package-card__head__title,{{WRAPPER}} .package-card__two__head__title,{{WRAPPER}} .price-card-fore__title,{{WRAPPER}} .pricing-two__table__head__item__title', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        hostom_elementor_general_style_options($this, 'Plan Type', '{{WRAPPER}} .package-card__body__pricing-plan,{{WRAPPER}} .package-card__two__body__pricing-plan', ['layout_two', 'layout_five']);
        hostom_elementor_general_style_options($this, 'Price', '{{WRAPPER}} .package-card__body__price,{{WRAPPER}} .package-card__two__body__price,{{WRAPPER}} .price-card-fore__price,{{WRAPPER}} .pricing-two__table__head__item__price__price', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        hostom_elementor_general_style_options($this, 'Duration', '{{WRAPPER}} .package-card__body__price__month,{{WRAPPER}} .package-card__two__body__price__month,{{WRAPPER}} .pricing-two__table__head__item__price__month', ['layout_one', 'layout_two', 'layout_three', 'layout_five']);
        hostom_elementor_general_style_options($this, 'Service List', '{{WRAPPER}} .package-card__content__list__item,{{WRAPPER}} .package-card__two__content__list__item,{{WRAPPER}} .price-card-fore__feature__list__item,{{WRAPPER}} .pricing-two__table__text', ['layout_one', 'layout_three', 'layout_four', 'layout_five']);

        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .hostom-btn--secondary,{{WRAPPER}} .hostom-btn', '{{WRAPPER}} .hostom-btn--secondary:hover, {{WRAPPER}} .hostom-btn:before', ['layout_one', 'layout_two', 'layout_three', 'layout_five']);

        $this->end_controls_section();

        hostom_get_elementor_carousel_options($this, ['layout_five']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('pricing-one.php');
        include hostom_get_template('pricing-two.php');
        include hostom_get_template('pricing-three.php');
        include hostom_get_template('pricing-four.php');
        include hostom_get_template('pricing-five.php');
    }
}
