<?php

namespace Layerdrops\Hostom\Widgets;


class Portfolio extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-portfolio';
    }

    public function get_title()
    {
        return __('Portfolio', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                    'layout_three' => __('Layout Three', 'hostom-addon'),
                    'layout_four' => __('Layout Four', 'hostom-addon'),
                    'layout_five' => __('Layout Five', 'hostom-addon'),
                    'layout_six' => __('Layout Six', 'hostom-addon'),
                    'layout_seven' => __('Layout Seven', 'hostom-addon'),
                    'layout_eight' => __('Layout Eight', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include hostom_get_elementor_option('portfolio-one-option.php');
        include hostom_get_elementor_option('portfolio-two-option.php');
        include hostom_get_elementor_option('portfolio-three-option.php');
        include hostom_get_elementor_option('portfolio-four-option.php');
        include hostom_get_elementor_option('portfolio-five-option.php');
        include hostom_get_elementor_option('portfolio-six-option.php');
        include hostom_get_elementor_option('portfolio-seven-option.php');
        include hostom_get_elementor_option('portfolio-eight-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_three', 'layout_two', 'layout_eight']);
        hostom_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_three', 'layout_two', 'layout_eight']);

        hostom_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .portfolio-one__title a,{{WRAPPER}} .portfolio-two__title a', ['layout_one', 'layout_three', 'layout_four', 'layout_two', 'layout_five', 'layout_six', 'layout_seven', 'layout_eight']);
        hostom_elementor_general_style_options($this, 'Tag Line', '{{WRAPPER}} .portfolio-two__cats a,{{WRAPPER}} .portfolio-one__cats a', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six', 'layout_seven', 'layout_eight']);
        hostom_elementor_general_style_options($this, 'Filter', '{{WRAPPER}} .portfolio-two__filter li .filter-text', ['layout_two']);


        $this->end_controls_section();

        hostom_get_elementor_carousel_options($this, ['layout_one', 'layout_seven', 'layout_eight']);
        hostom_elementor_column_count_options($this, ['layout_three', 'layout_four', 'layout_six']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('portfolio-one.php');
        include hostom_get_template('portfolio-two.php');
        include hostom_get_template('portfolio-three.php');
        include hostom_get_template('portfolio-four.php');
        include hostom_get_template('portfolio-five.php');
        include hostom_get_template('portfolio-six.php');
        include hostom_get_template('portfolio-seven.php');
        include hostom_get_template('portfolio-eight.php');
    }
}
