<?php

namespace Layerdrops\Hostom\Widgets;


class Pagination extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-pagination';
    }

    public function get_title()
    {
        return __('Pagination', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        include hostom_get_elementor_option('pagination-one-option.php');


        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Prev/Next Text', '{{WRAPPER}} .portfolio-details__pagination__previous span, {{WRAPPER}} .portfolio-details__pagination__next span', ['layout_one']);
        hostom_elementor_general_style_options($this, 'Project Text', '{{WRAPPER}} .portfolio-details__pagination__previous,{{WRAPPER}} .portfolio-details__pagination__next', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        include hostom_get_template('pagination-one.php');
    }
}
