<?php

namespace Layerdrops\Hostom\Widgets;


class MainSlider extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-main-slider';
    }

    public function get_title()
    {
        return __('Main Slider', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                    'layout_three' => __('Layout Three', 'hostom-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        include hostom_get_elementor_option('main-slider-one-option.php');
        include hostom_get_elementor_option('main-slider-two-option.php');
        include hostom_get_elementor_option('main-slider-three-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .main-slider-one__title, {{WRAPPER}} .main-slider-two__title, {{WRAPPER}} .main-slider-three__title', ['layout_one', 'layout_two', 'layout_three']);
        hostom_elementor_general_style_options($this, 'Sub Title', '{{WRAPPER}} .main-slider-one__sub-title, {{WRAPPER}} .main-slider-two__sub-title, {{WRAPPER}} .main-slider-three__sub-title', ['layout_one', 'layout_two', 'layout_three']);
        hostom_elementor_general_style_options($this, 'Video Text', '{{WRAPPER}} .curved-circle--item span', ['layout_three']);

        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .hostom-btn::before', '{{WRAPPER}} .hostom-btn::after', ['layout_one', 'layout_two', 'layout_three']);

        $this->end_controls_section();

        hostom_get_elementor_carousel_options($this, ['layout_one', 'layout_two', 'layout_three']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('main-slider-one.php');
        include hostom_get_template('main-slider-two.php');
        include hostom_get_template('main-slider-three.php');
    }
}
