<?php

namespace Layerdrops\Hostom\Widgets;


class Login extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-login';
    }

    public function get_title()
    {
        return __('Login', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'login_content_section',
            [
                'label' => __('Login', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );

        $this->add_control(
            'login_info',
            [
                'label' => __('Login Info', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::CODE,
                'default' => __('We have a demo account setup. <span>Username:</span> <a href="login.html">demo</a> and <span> Password:</span> <a href="login.html">demo</a> ', 'hostom-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'login_title',
            [
                'label' => __('Title', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Login ', 'hostom-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'login_user_name_placeholder',
            [
                'label' => __('Placeholder for username', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Username or Email Address* ', 'hostom-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'login_password_placeholder',
            [
                'label' => __('Placeholder for Password', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Password* ', 'hostom-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'login_remember_me_text',
            [
                'label' => __('Remember Me Text', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Remember Me?', 'hostom-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'login_btn_text',
            [
                'label' => __('Login Button Text', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Login', 'hostom-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'login_forget_text',
            [
                'label' => __('Forgot Password Text', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Forgot your Password?', 'hostom-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'login_forget_url',
            [
                'label' => __('Forgot Password Url', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'hostom-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'register_content_section',
            [
                'label' => __('Content', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );
        $this->add_control(
            'register_title',
            [
                'label' => __('Title', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Register ', 'hostom-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'register_email_placeholder',
            [
                'label' => __('Email Placeholder', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Email Address', 'hostom-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'register_password_placeholder',
            [
                'label' => __('Placeholder for Password', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Password* ', 'hostom-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'register_privacy_text',
            [
                'label' => __('Privacy Text', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('I accept company <a href="#">privacy policy</a>.', 'hostom-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'register_btn_text',
            [
                'label' => __('Register Button Text', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Register', 'hostom-addon'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'style_options',
            [
                'label' => esc_html__('Style Options', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .login-page__wrap__title', ['layout_one']);
        hostom_elementor_general_style_options($this, 'Forget Password Text', '{{WRAPPER}} .login-page__form-forgot-password a', ['layout_one']);
        hostom_elementor_general_style_options($this, 'Other Text', '{{WRAPPER}} .login-page__checked-box label', ['layout_one']);
        hostom_elementor_general_style_options($this, 'Login Info', '{{WRAPPER}} .login-page__info p', ['layout_one']);
        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .hostom-btn', '{{WRAPPER}} .hostom-btn:hover', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('login-one.php');
    }
}
