<?php

namespace Layerdrops\Hostom\Widgets;


class IconBox extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-icon-box';
    }

    public function get_title()
    {
        return __('Icon Box', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include hostom_get_elementor_option('icon-box-one-option.php');
        include hostom_get_elementor_option('icon-box-two-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .portfolio-details__box__title,{{WRAPPER}} .services-details__box__title', ['layout_one', 'layout_two']);
        hostom_elementor_general_style_options($this, 'Content', '{{WRAPPER}} .portfolio-details__box__text', ['layout_one']);
        hostom_elementor_general_style_options($this, 'Icon', '{{WRAPPER}} .portfolio-details__box__icon span,{{WRAPPER}} .services-details__box__icon span', ['layout_one', 'layout_two']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('icon-box-one.php');
        include hostom_get_template('icon-box-two.php');
    }
}
