<?php

namespace Layerdrops\Hostom\Widgets;


class HomeShowCase extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-home-showcase-box';
    }

    public function get_title()
    {
        return __('Home ShowCase', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                ]
            ]
        );



        $megamenu_box_list = new \Elementor\Repeater();

        $megamenu_box_list->add_control(
            'heading',
            [
                'label' => __('Heading', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => '2',
                'default' => wp_kses(__('Heading', 'hostom-addon'), 'hostom_allowed_tags'),
                'label_block' => true,
            ]
        );

        hostom_elementor_heading_option($megamenu_box_list, 'Home Showcase Heading', 'h3', 'layout_one');

        $megamenu_box_list->add_control(
            'image',
            [
                'label' => __('Image', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $megamenu_box_list->add_control(
            'multi_page_title',
            [
                'label' => __('Multi Page Title', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => '2',
                'default' => wp_kses(__('Multi Page', 'hostom-addon'), 'hostom_allowed_tags'),
                'label_block' => true,
            ]
        );

        $megamenu_box_list->add_control(
            'multi_page_url',
            [
                'label' => __('Url', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'hostom-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $megamenu_box_list->add_control(
            'one_page_title',
            [
                'label' => __('One Page Title', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => '2',
                'default' => wp_kses(__('One Page', 'hostom-addon'), 'hostom_allowed_tags'),
                'label_block' => true,
            ]
        );

        $megamenu_box_list->add_control(
            'one_page_url',
            [
                'label' => __('Url', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'hostom-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $megamenu_box_list->add_control(
            'dark_page_title',
            [
                'label' => __('Dark Page Title', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => '2',
                'default' => wp_kses(__('Dark Page', 'hostom-addon'), 'hostom_allowed_tags'),
                'label_block' => true,
            ]
        );

        $megamenu_box_list->add_control(
            'dark_page_url',
            [
                'label' => __('Url', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'hostom-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $this->add_control(
            'megamenu_box_list',
            [
                'label' => __('Mega Menu List', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $megamenu_box_list->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ heading }}}',
            ]
        );


        $this->end_controls_section();

        //Content style
        $this->start_controls_section(
            'content_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Heading', '{{WRAPPER}} .home-showcase__title,{{WRAPPER}} .demo-one__title a', ['layout_one', 'layout_two']);

        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .hostom-btn', '{{WRAPPER}} .hostom-btn:hover', ['layout_one', 'layout_two', 'layout_three']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('home-showcase-one.php');
        include hostom_get_template('home-showcase-two.php');
    }
}
