<?php

namespace Layerdrops\Hostom\Widgets;


class Header extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-header';
    }

    public function get_title()
    {
        return __('Header', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout Type', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                    'layout_three' => __('Layout Three', 'hostom-addon'),
                    'layout_four' => __('Layout Four', 'hostom-addon'),
                    'layout_five' => __('Layout Five', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include hostom_get_elementor_option('header-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Menu', '{{WRAPPER}} .main-menu .main-menu__list > li > a,{{WRAPPER}} .main-menu .main-menu__list > li > ul > li > a', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        hostom_elementor_general_style_options($this, 'Top Contact', '{{WRAPPER}} .topbar-one__info__item a,{{WRAPPER}} .topbar-one__info__item span', ['layout_two']);

        hostom_elementor_general_style_options($this, 'Call Text', '{{WRAPPER}} .info__item__content__text', ['layout_three', 'layout_four']);
        hostom_elementor_general_style_options($this, 'Call Number', '{{WRAPPER}} .info__item__content__call', ['layout_three', 'layout_four']);

        hostom_elementor_general_style_options($this, 'Icon', '{{WRAPPER}} .main-header__right__social a i,{{WRAPPER}} .main-header__right__info .info__item i,{{WRAPPER}} .topbar-one__social a', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);


        $this->end_controls_section();

        //Button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .hostom-btn', '{{WRAPPER}} .hostom-btn::before', ['layout_two']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('header.php');
    }
}
