<?php

namespace Layerdrops\Hostom\Widgets;


class Gallery extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-gallery';
    }

    public function get_title()
    {
        return __('Gallery', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                    'layout_three' => __('Layout Three', 'hostom-addon'),
                    'layout_four' => __('Layout Four', 'hostom-addon'),
                    'layout_five' => __('Layout Five', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include hostom_get_elementor_option('gallery-one-option.php');
        include hostom_get_elementor_option('gallery-two-option.php');
        include hostom_get_elementor_option('gallery-three-option.php');
        include hostom_get_elementor_option('gallery-four-option.php');
        include hostom_get_elementor_option('gallery-five-option.php');


        hostom_get_elementor_carousel_options($this, ['layout_three']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('gallery-one.php');
        include hostom_get_template('gallery-two.php');
        include hostom_get_template('gallery-three.php');
        // include hostom_get_template('gallery-four.php');
        // include hostom_get_template('gallery-five.php');
    }
}
