<?php

namespace Layerdrops\Hostom\Widgets;


class Funfact extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-funfact';
    }

    public function get_title()
    {
        return __('Funfact', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                    'layout_three' => __('Layout Three', 'hostom-addon'),
                    'layout_four' => __('Layout Four', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include hostom_get_elementor_option('funfact-one-option.php');
        include hostom_get_elementor_option('funfact-two-option.php');
        include hostom_get_elementor_option('funfact-three-option.php');
        include hostom_get_elementor_option('funfact-four-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .sec-title__title', ['layout_four']);
        hostom_elementor_general_style_options($this, 'Section Subtitle', '{{WRAPPER}} .sec-title__tagline', ['layout_four']);
        hostom_elementor_general_style_options($this, 'Summary', '{{WRAPPER}} .funfact-fore__text', ['layout_four']);

        hostom_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .funfact-one__text,{{WRAPPER}} .funfact-three__text,{{WRAPPER}} .funfact-fore__list__text', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        hostom_elementor_general_style_options($this, 'Number', '{{WRAPPER}} .funfact-one__count span:first-child,{{WRAPPER}} .funfact-three__count span:first-child,{{WRAPPER}} .funfact-fore__list__count span:first-child', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        hostom_elementor_general_style_options($this, 'Symbol', '{{WRAPPER}} .funfact-one__count span:last-child,.funfact-three__count span:last-child, {{WRAPPER}} .funfact-fore__list__count span:last-child', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

        $this->end_controls_section();

        //Button style
        // $this->start_controls_section(
        //     'button_style',
        //     [
        //         'label' => esc_html__('Button Style', 'hostom-addon'),
        //         'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        //     ]
        // );

        // hostom_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .hostom-btn::before', '{{WRAPPER}} .hostom-btn::after', ['layout_one']);

        // $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('funfact-one.php');
        include hostom_get_template('funfact-two.php');
        include hostom_get_template('funfact-three.php');
        include hostom_get_template('funfact-four.php');
    }
}
