<?php

namespace Layerdrops\Hostom\Widgets;


class FooterSubscribe extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'footer-subscribe';
    }

    public function get_title()
    {
        return __('Footer Subscribe', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                    'layout_three' => __('Layout Three', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .footer-widget__title', ['layout_one', 'layout_two']);
        hostom_elementor_general_style_options($this, 'Bottom Text', '{{WRAPPER}} .footer-widget__text', ['layout_one', 'layout_two', 'layout_three']);
        hostom_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .footer-widget__newsletter button[type=submit]', '{{WRAPPER}} .footer-widget__newsletter button[type=submit]:hover', ['layout_one', 'layout_three']);

        hostom_elementor_general_style_options($this, 'Contact Info', '{{WRAPPER}} .footer-widget__info li', ['layout_three']);
        $this->end_controls_section();

        include hostom_get_elementor_option('footer-subscribe-one-option.php');
        include hostom_get_elementor_option('footer-subscribe-two-option.php');
        include hostom_get_elementor_option('footer-subscribe-three-option.php');
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('footer-subscribe-one.php');
        include hostom_get_template('footer-subscribe-two.php');
        include hostom_get_template('footer-subscribe-three.php');
    }
}
