<?php

namespace Layerdrops\Hostom\Widgets;


class FooterAbout extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'footer-about';
    }

    public function get_title()
    {
        return __('Footer About', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include hostom_get_elementor_option('footer-about-one-option.php');
        include hostom_get_elementor_option('footer-about-two-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        hostom_elementor_general_style_options($this, 'Text', '{{WRAPPER}} .footer-widget__text', ['layout_one', 'layout_two']);
        hostom_elementor_button_style_options($this, 'Social Icon', '{{WRAPPER}} .footer-widget__social a', '{{WRAPPER}} .footer-widget__social a:hover', ['layout_one', 'layout_two']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('footer-about-one.php');
        include hostom_get_template('footer-about-two.php');
    }
}
