<?php

namespace Layerdrops\Hostom\Widgets;


class Faq extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'hostom-faq';
	}

	public function get_title()
	{
		return __('FAQ', 'hostom-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['hostom-category'];
	}

	protected function register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'hostom-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'hostom-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'hostom-addon'),
					'layout_two' => __('Layout Two', 'hostom-addon'),
					'layout_three' => __('Layout Three', 'hostom-addon'),
					'layout_four' => __('Layout Four', 'hostom-addon'),
					'layout_five' => __('Layout Five', 'hostom-addon'),
				]
			]
		);

		$this->end_controls_section();

		include hostom_get_elementor_option('faq-one-option.php');
		include hostom_get_elementor_option('faq-two-option.php');
		include hostom_get_elementor_option('faq-three-option.php');
		include hostom_get_elementor_option('faq-four-option.php');
		include hostom_get_elementor_option('faq-five-option.php');

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Content Style', 'hostom-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		hostom_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .faq-page__contact__title,{{WRAPPER}} .sec-title__title ', ['layout_one', 'layout_two']);
		hostom_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .faq-page__contact__title,{{WRAPPER}} .sec-title__tagline', ['layout_one', 'layout_two']);

		hostom_elementor_general_style_options($this, 'Question', '{{WRAPPER}} .faq-page__accordion .accrodion-title h4,{{WRAPPER}} .faq-page__accordion .accrodion-title__text', ['layout_one', 'layout_two', 'layout_three']);
		hostom_elementor_general_style_options($this, 'Answer', '{{WRAPPER}} .faq-page__accordion .accrodion-content p,{{WRAPPER}} .faq-page__accordion .accrodion-content p', ['layout_one', 'layout_two', 'layout_three']);

		hostom_elementor_general_style_options($this, 'Email Text', '{{WRAPPER}} .faq-page__thumb__card__title ', ['layout_three']);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include hostom_get_template('faq-one.php');
		include hostom_get_template('faq-two.php');
		include hostom_get_template('faq-three.php');
		include hostom_get_template('faq-four.php');
		include hostom_get_template('faq-five.php');
	}
}
