<?php

namespace Layerdrops\Hostom\Widgets;


class DomainSearch extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-domain-search';
    }

    public function get_title()
    {
        return __('Domain Search', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                    'layout_three' => __('Layout Three', 'hostom-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        include hostom_get_elementor_option('domain-one-option.php');
        include hostom_get_elementor_option('domain-two-option.php');
        include hostom_get_elementor_option('domain-three-option.php');


        $this->start_controls_section(
            'ajax_content',
            [
                'label' => __('Domain Validation', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'if_domain_empty',
            [
                'label' => __('If Domain Empty', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => '2',
                'placeholder' => __('If Domain Field Empty', 'hostom-addon'),
                'default' => __('Please enter a domain.', 'hostom-addon'),
            ]
        );

        $this->add_control(
            'if_invalid_tld',
            [
                'label' => __('If Invalid TLD', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => '2',
                'placeholder' => __('If Invalid TLD', 'hostom-addon'),
                'default' => __('Invalid top-level domain.', 'hostom-addon'),
            ]
        );

        $this->add_control(
            'if_domain_available',
            [
                'label' => __('If Domain Available', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => '2',
                'placeholder' => __('If Domain Available', 'hostom-addon'),
                'default' => __('is available for registration!', 'hostom-addon'),
                'desc' => __('Search Domain name come in first')
            ]
        );

        $this->add_control(
            'if_domain_unavailable',
            [
                'label' => __('If Domain Unavailable', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => '2',
                'placeholder' => __('If Domain unavailable', 'hostom-addon'),
                'default' => __('is not available for registration.', 'hostom-addon'),
                'desc' => __('Search Domain name come in first')
            ]
        );

        $this->add_control(
            'available_tld',
            [
                'label' => __('Available Tld', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => '2',
                'placeholder' => __('Available Tld', 'hostom-addon'),
                'default' => __("'com', 'co', 'info', 'net', 'edu'", 'hostom-addon'),
            ]
        );

        $this->add_control(
            'btn_label',
            [
                'label' => __('Button Label', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => '2',
                'placeholder' => __('Add Button Label', 'hostom-addon'),
                'default' => __("Buy Now", 'hostom-addon'),
            ]
        );

        $this->add_control(
            'whmcs_url',
            [
                'label' => __('WHMCS Url', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => '2',
                'placeholder' => __('WHMCS Url', 'hostom-addon'),
                'default' => __("#", 'hostom-addon'),
            ]
        );

        $this->end_controls_section();


        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Domain Info TLDs', '{{WRAPPER}} .domain-name__list__item span,{{WRAPPER}} .domain-name-two__list__item span', ['layout_one', 'layout_two', 'layout_three']);
        hostom_elementor_general_style_options($this, 'Domain Info Price', '{{WRAPPER}} .domain-name__list__item,{{WRAPPER}} .domain-name-two__list__item ', ['layout_one', 'layout_two', 'layout_three']);

        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .hostom-btn', '{{WRAPPER}} .hostom-btn::before', ['layout_one', 'layout_two', 'layout_three']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('domain-search-one.php');
        include hostom_get_template('domain-search-two.php');
        include hostom_get_template('domain-search-three.php');
    }
}
