<?php

namespace Layerdrops\Hostom\Widgets;


class ContactInfo extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-contact-info';
    }

    public function get_title()
    {
        return __('Contact Info', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include hostom_get_elementor_option('contact-info-one-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .faq-page__help__title', ['layout_one']);
        hostom_elementor_general_style_options($this, 'Content', '{{WRAPPER}} .faq-page__help__text ', ['layout_one']);

        hostom_elementor_general_style_options($this, 'Contact Info Title', '{{WRAPPER}} .contact__box__title', ['layout_one']);
        hostom_elementor_general_style_options($this, 'Contact Info Content', '{{WRAPPER}} .contact__box__text,{{WRAPPER}} .contact__box__text a', ['layout_one']);

        hostom_elementor_general_style_options($this, 'Icon', '{{WRAPPER}} .contact__box__icon span', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('contact-info-one.php');
    }
}
