<?php

namespace Layerdrops\Hostom\Widgets;


class ContactForm extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-contact-form';
    }

    public function get_title()
    {
        return __('Contact Form', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                    'layout_three' => __('Layout Three', 'hostom-addon'),
                    'layout_four' => __('Layout Four', 'hostom-addon'),
                    // 'layout_five' => __('Layout Five', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include hostom_get_elementor_option('contact-form-one-option.php');
        include hostom_get_elementor_option('contact-form-two-option.php');
        include hostom_get_elementor_option('contact-form-three-option.php');
        include hostom_get_elementor_option('contact-form-four-option.php');
        // include hostom_get_elementor_option('contact-form-five-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .sec-title__title', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        hostom_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .sec-title__tagline', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);


        $this->end_controls_section();

        //contact info style
        $this->start_controls_section(
            'contact_info_style',
            [
                'label' => esc_html__('Contact Info Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_type' => ['layout_two']
                ]
            ]
        );

        hostom_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .contact-one__content__top__text', 'layout_two');
        hostom_elementor_general_style_options($this, 'Sub Title', '{{WRAPPER}} .contact-one__content__top__text span', 'layout_two');

        hostom_elementor_general_style_options($this, 'Contact Info Title', '{{WRAPPER}} .contact-one__info__text', 'layout_two');
        hostom_elementor_general_style_options($this, 'Contact Info Content', '{{WRAPPER}} .contact-one__info__title a', 'layout_two');

        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .hostom-btn,{{WRAPPER}} .hostom-btn::before', '{{WRAPPER}} .hostom-btn:hover,{{WRAPPER}} .hostom-btn::after', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

        $this->end_controls_section();

        //form Option style
        $this->start_controls_section(
            'form_style',
            [
                'label' => esc_html__('Form Field Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_form_style_options($this, 'Input Text', '{{WRAPPER}} input[type="text"]', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        hostom_elementor_form_style_options($this, 'Input Email', '{{WRAPPER}} input[type="email"]', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        hostom_elementor_form_style_options($this, 'Textarea', '{{WRAPPER}}  textarea', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        hostom_elementor_form_style_options($this, 'Input Url', '{{WRAPPER}} input[type="url"]', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        hostom_elementor_form_style_options($this, 'Input Number', '{{WRAPPER}} input[type="number"]', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        hostom_elementor_form_style_options($this, 'Input Tel', '{{WRAPPER}} input[type="tel"]', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('contact-form-one.php');
        include hostom_get_template('contact-form-two.php');
        // include hostom_get_template('contact-form-three.php');
        // include hostom_get_template('contact-form-four.php');
        // include hostom_get_template('contact-form-five.php');
    }
}
