<?php

namespace Layerdrops\Hostom\Widgets;


class CallToAction extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-call-to-action';
    }

    public function get_title()
    {
        return __('Call To Action', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                    'layout_three' => __('Layout Three', 'hostom-addon'),
                    'layout_four' => __('Layout Four', 'hostom-addon'),
                ]
            ]
        );
        $this->end_controls_section();

        include hostom_get_elementor_option('call-to-action-one-option.php');
        include hostom_get_elementor_option('call-to-action-two-option.php');
        include hostom_get_elementor_option('call-to-action-three-option.php');
        include hostom_get_elementor_option('call-to-action-four-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Title', '{{WRAPPER}} .cta-fore__text,{{WRAPPER}} .cta-five__title,{{WRAPPER}} .cta-seven__title', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        $this->end_controls_section();

        //button style
        $this->start_controls_section(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two', 'layout_three', 'layout_four']
                ]
            ]
        );

        hostom_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .hostom-btn', '{{WRAPPER}} .hostom-btn::before', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('call-to-action-one.php');
        include hostom_get_template('call-to-action-two.php');
        include hostom_get_template('call-to-action-three.php');
        include hostom_get_template('call-to-action-four.php');
    }
}
