<?php

namespace Layerdrops\Hostom\Widgets;


class Blog extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'hostom-blog';
    }

    public function get_title()
    {
        return __('Blog', 'hostom-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['hostom-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'hostom-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'hostom-addon'),
                    'layout_two' => __('Layout Two', 'hostom-addon'),
                    'layout_three' => __('Layout Three', 'hostom-addon'),
                    'layout_four' => __('Layout Four', 'hostom-addon'),
                    'layout_five' => __('Layout Five', 'hostom-addon'),
                    'layout_six' => __('Layout Six', 'hostom-addon'),
                    'layout_seven' => __('Layout Seven', 'hostom-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        include  hostom_get_elementor_option('blog-option.php');

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Content Style', 'hostom-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        hostom_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .sec-title__title', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        hostom_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .sec-title__tagline', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

        hostom_elementor_general_style_options($this, 'Post Title', '{{WRAPPER}} .blog-card__title a,{{WRAPPER}} .blog-card-three__title a,{{WRAPPER}} .blog-card__fore__title a,{{WRAPPER}} .blog-card__five__title', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six']);
        hostom_elementor_general_style_options($this, 'Post Meta', '{{WRAPPER}} .comments-link a,{{WRAPPER}} .blog-card__fore__meta__comment, {{WRAPPER}} .blog-card__content .blog-card__meta a', ['layout_one', 'layout_two', 'layout_three', 'layout_five', 'layout_six']);
        hostom_elementor_general_style_options($this, 'Summary Text', '{{WRAPPER}} .blog-card__five__text', ['layout_four']);
        hostom_elementor_general_style_options($this, 'Author', '{{WRAPPER}} .blog-card__five__author__title', ['layout_four']);
        hostom_elementor_general_style_options($this, 'Comment', '{{WRAPPER}} .blog-card__five__comments', ['layout_four']);

        hostom_elementor_general_style_options($this, 'Read More', '{{WRAPPER}} .blog-card__content__btn__link,{{WRAPPER}} .blog-card-three__content__btn a,{{WRAPPER}} .blog-card__fore__content__btn a,{{WRAPPER}}  .blog-card__five__btn a', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six']);

        $this->end_controls_section();
        hostom_get_elementor_carousel_options($this, ['layout_six']);
        hostom_elementor_column_count_options($this, ['layout_five']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include hostom_get_template('blog-one.php');
        include hostom_get_template('blog-two.php');
        include hostom_get_template('blog-three.php');
        include hostom_get_template('blog-four.php');
        include hostom_get_template('blog-five.php');
        include hostom_get_template('blog-six.php');
        include hostom_get_template('blog-seven.php');
    }
}
