<?php

namespace Layerdrops\Hostom\Widgets;


class About extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'hostom-about';
	}

	public function get_title()
	{
		return __('About', 'hostom-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['hostom-category'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'hostom-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'hostom-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'hostom-addon'),
					'layout_two' => __('Layout Two', 'hostom-addon'),
					'layout_three' => __('Layout Three', 'hostom-addon'),
					'layout_four' => __('Layout Four', 'hostom-addon'),
					'layout_five' => __('Layout Five', 'hostom-addon'),
					'layout_six' => __('Layout Six', 'hostom-addon'),
					'layout_seven' => __('Layout Seven', 'hostom-addon'),
					'layout_eight' => __('Layout Eight', 'hostom-addon'),
					'layout_nine' => __('Layout Nine', 'hostom-addon'),
				]
			]
		);

		$this->end_controls_section();

		include hostom_get_elementor_option('about-one-option.php');
		include hostom_get_elementor_option('about-two-option.php');
		include hostom_get_elementor_option('about-three-option.php');
		include hostom_get_elementor_option('about-four-option.php');
		include hostom_get_elementor_option('about-five-option.php');
		include hostom_get_elementor_option('about-six-option.php');
		include hostom_get_elementor_option('about-seven-option.php');
		include hostom_get_elementor_option('about-eight-option.php');
		include hostom_get_elementor_option('about-nine-option.php');

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Content Style', 'hostom-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		hostom_elementor_general_style_options($this, 'Section Title', '{{WRAPPER}} .sec-title__title', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six', 'layout_seven', 'layout_eight', 'layout_nine']);
		hostom_elementor_general_style_options($this, 'Section Sub Title', '{{WRAPPER}} .sec-title__tagline', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six', 'layout_seven', 'layout_eight', 'layout_nine']);

		hostom_elementor_general_style_options($this, 'Summary Text', '{{WRAPPER}} .about-three__top__text,{{WRAPPER}} .choose-us-one__top__text, {{WRAPPER}} .about-two__top__text,{{WRAPPER}} .why-choos-three__top__text, {{WRAPPER}} .about-fore__text, {{WRAPPER}} .benefits-three__text, {{WRAPPER}} .about-five__text, {{WRAPPER}} .why-choos-fore__text', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six', 'layout_seven', 'layout_eight', 'layout_nine']);
		//hostom_elementor_general_style_options($this, 'Highlighted Text', '{{WRAPPER}} .why-choose-two__highlight,{{WRAPPER}} .about-one__content__text-one', ['layout_two']);

		//hostom_elementor_general_style_options($this, 'Progress Title', '{{WRAPPER}} .why-choose-two__text', ['layout_one']);
		//hostom_elementor_general_style_options($this, 'Progress Number', '{{WRAPPER}} .why-choose-two__progress__number', ['layout_one']);

		hostom_elementor_general_style_options($this, 'Features Title', '{{WRAPPER}} .choose-us-one__feature__title,{{WRAPPER}} .why-choos-three__feature__icon__title,{{WRAPPER}} .benefits-three__list__title a,{{WRAPPER}} .about-five__feature__icon__title', ['layout_two', 'layout_four', 'layout_six', 'layout_seven']);
		hostom_elementor_general_style_options($this, 'Features Content', '{{WRAPPER}} .choose-us-one__feature__title,{{WRAPPER}} .why-choos-three__feature__text,{{WRAPPER}} .benefits-three__list__text', ['layout_four', 'layout_six']);

		hostom_elementor_general_style_options($this, 'Check List Title', '{{WRAPPER}} .about-three__content__list__item,{{WRAPPER}} .choose-us-one__list__item,{{WRAPPER}} .about-two__list__item,{{WRAPPER}} .about-fore__item__list', ['layout_one', 'layout_two', 'layout_three', 'layout_five', 'layout_nine']);
		hostom_elementor_general_style_options($this, 'Domain', '{{WRAPPER}} .about-three__content__box__title span,{{WRAPPER}} .about-fore__content__box__domine', ['layout_one', 'layout_five', 'layout_nine']);
		hostom_elementor_general_style_options($this, 'Domain Price', '{{WRAPPER}} .about-three__content__box__price, {{WRAPPER}} .about-fore__content__box__price', ['layout_one', 'layout_five', 'layout_nine']);

		hostom_elementor_general_style_options($this, 'Call Text', '{{WRAPPER}} .about-three__thumb__item__card__subtitle', ['layout_one', 'layout_nine']);
		hostom_elementor_general_style_options($this, 'Call Number ', '{{WRAPPER}} .about-three__thumb__item__card__call', ['layout_one', 'layout_nine']);
		hostom_elementor_general_style_options($this, 'Call Icon', '{{WRAPPER}} .about-three__thumb__item__card__icon i', ['layout_one', 'layout_nine']);

		hostom_elementor_general_style_options($this, 'Image Caption', '{{WRAPPER}} .why-choos-three__thumb__card__text', ['layout_four']);

		hostom_elementor_general_style_options($this, 'Progressbar Title', '{{WRAPPER}} .about-five__team-skills__progress__title', ['layout_seven']);

		hostom_elementor_general_style_options($this, 'Count Number', '{{WRAPPER}} .why-choos-fore__feature__item__funfact__count span', ['layout_eight']);
		hostom_elementor_general_style_options($this, 'Count Text', '{{WRAPPER}} .why-choos-fore__feature__item__text', ['layout_eight']);

		hostom_elementor_general_style_options($this, 'Icon Title', '{{WRAPPER}} .why-choos-fore__feature__item__content__title', ['layout_eight']);
		hostom_elementor_general_style_options($this, 'Icon Text', '{{WRAPPER}} .why-choos-fore__feature__item__content__text', ['layout_eight']);

		$this->end_controls_section();

		//Button style
		$this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__('Button Style', 'hostom-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		hostom_elementor_button_style_options($this, 'Button', '{{WRAPPER}} .hostom-btn--secondary, {{WRAPPER}} .hostom-btn', '{{WRAPPER}} ..hostom-btn--secondary::before, {{WRAPPER}} .hostom-btn::before', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include hostom_get_template('about-one.php');
		include hostom_get_template('about-two.php');
		include hostom_get_template('about-three.php');
		include hostom_get_template('about-four.php');
		include hostom_get_template('about-five.php');
		include hostom_get_template('about-six.php');
		include hostom_get_template('about-seven.php');
		include hostom_get_template('about-eight.php');
		include hostom_get_template('about-nine.php');
	}
}
