<?php

namespace Layerdrops\Hostom\SidebarWidget;

/**
 * The Recent Post Widget class
 */

class RecentPost extends \WP_Widget
{

    function __construct()
    {
        parent::__construct(
            'custom_recent_posts_widget',
            __('Hostom Recent Posts', 'hostom-addon'),
            array('description' => __('A custom widget for displaying recent posts with filtering, ordering, and category options.', 'hostom-addon'))
        );
    }

    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
        $post_count = intval($instance['post_count']);
        $order_by = $instance['order_by'];
        $order = $instance['order']; // New order field
        $category_filter = !empty($instance['category_filter']) ? $instance['category_filter'] : array();

        $post_args = array(
            'posts_per_page' => $post_count,
            'orderby' => $order_by,
            'order' => $order,
            'post_status' => 'publish',
            'ignore_sticky_posts' => true,
        );

        if (!empty($category_filter) && !in_array(0, $category_filter)) {
            $post_args['category__in'] = $category_filter;
        }
        $recent_posts = new \WP_Query($post_args);

        echo $args['before_widget'];
        if ($title) {
            echo $args['before_title'] . $title . $args['after_title'];
        }
        if ($recent_posts->have_posts()) {
            include  hostom_get_sidebar_template('recent-post.php');
?>

        <?php }
        echo $args['after_widget'];
    }

    public function form($instance)
    {
        $title = !empty($instance['title']) ? $instance['title'] : __('Recent Posts', 'hostom-addon');
        $title_word_limit = !empty($instance['title_word_limit']) ? $instance['title_word_limit'] : 15;
        $post_count = !empty($instance['post_count']) ? $instance['post_count'] : 5;
        $order_by = !empty($instance['order_by']) ? $instance['order_by'] : 'date';
        $order = !empty($instance['order']) ? $instance['order'] : 'desc';
        $category_filter = !empty($instance['category_filter']) ? $instance['category_filter'] : 0;

        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'hostom-addon'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('post_count'); ?>"><?php _e('Number of Posts:', 'hostom-addon'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('post_count'); ?>" name="<?php echo $this->get_field_name('post_count'); ?>" type="number" value="<?php echo esc_attr($post_count); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('title_word_limit'); ?>"><?php _e('Post Title Word Limit:', 'hostom-addon'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title_word_limit'); ?>" name="<?php echo $this->get_field_name('title_word_limit'); ?>" type="number" value="<?php echo esc_attr($title_word_limit); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('order_by'); ?>"><?php _e('Order By:', 'hostom-addon'); ?></label>
            <select class="widefat" id="<?php echo $this->get_field_id('order_by'); ?>" name="<?php echo $this->get_field_name('order_by'); ?>">
                <option value="date" <?php selected($order_by, 'date'); ?>><?php _e('Date', 'hostom-addon'); ?></option>
                <option value="title" <?php selected($order_by, 'title'); ?>><?php _e('Title', 'hostom-addon'); ?></option>
            </select>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('order'); ?>"><?php _e('Order:', 'hostom-addon'); ?></label>
            <select class="widefat" id="<?php echo $this->get_field_id('order'); ?>" name="<?php echo $this->get_field_name('order'); ?>">
                <option value="desc" <?php selected($order, 'desc'); ?>><?php _e('Descending', 'hostom-addon'); ?></option>
                <option value="asc" <?php selected($order, 'asc'); ?>><?php _e('Ascending', 'hostom-addon'); ?></option>
            </select>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('category_filter'); ?>"><?php _e('Category Filter:', 'hostom-addon'); ?></label>
            <select class="widefat" id="<?php echo $this->get_field_id('category_filter'); ?>" name="<?php echo $this->get_field_name('category_filter'); ?>[]" multiple="multiple">
                <?php
                $categories = get_categories();
                foreach ($categories as $category) {
                    echo '<option value="' . esc_attr($category->term_id) . '" ' . selected(in_array($category->term_id, (array) $category_filter), true, false) . '>' . esc_html($category->name) . '</option>';
                }
                ?>
            </select>
        </p>
<?php
    }

    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = sanitize_text_field($new_instance['title']);
        $instance['title_word_limit'] = intval($new_instance['title_word_limit']);
        $instance['post_count'] = intval($new_instance['post_count']);
        $instance['order_by'] = sanitize_text_field($new_instance['order_by']);
        $instance['order'] = sanitize_text_field($new_instance['order']); // Save order
        $instance['category_filter'] = array_map('intval', $new_instance['category_filter']); // Update to an array of integers
        return $instance;
    }
}
