<?php

namespace Layerdrops\Hostom\SidebarWidget;

/**
 * The Recent Post Widget class
 */

class BlogComments extends \WP_Widget
{

    function __construct()
    {
        parent::__construct(
            'hostom_blog_comments_widget',
            __('Hostom Blog Comments', 'hostom-addon'),
            array('description' => __('A custom widget for Blog Comments', 'hostom-addon'))
        );
    }

    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
        $comment_count = intval($instance['comment_count']);


        echo $args['before_widget'];
        if ($title) {
            echo $args['before_title'] . $title . $args['after_title'];
        }
        include  hostom_get_sidebar_template('blog-comments.php');
?>

    <?php
        echo $args['after_widget'];
    }

    public function form($instance)
    {
        $title = !empty($instance['title']) ? $instance['title'] : __('Comments', 'hostom-addon');
        $comment_count = !empty($instance['comment_count']) ? $instance['comment_count'] : 5;


    ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'hostom-addon'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('comment_count'); ?>"><?php _e('Number of Comments:', 'hostom-addon'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('comment_count'); ?>" name="<?php echo $this->get_field_name('comment_count'); ?>" type="number" value="<?php echo esc_attr($comment_count); ?>">
        </p>
<?php
    }

    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = sanitize_text_field($new_instance['title']);
        $instance['comment_count'] = intval($new_instance['comment_count']);
        return $instance;
    }
}
