<?php

namespace Layerdrops\Hostom\SidebarWidget;

/**
 * The Recent Post Widget class
 */

class BlogCategories extends \WP_Widget
{

    function __construct()
    {
        parent::__construct(
            'hostom_blog_categories_widget',
            __('Hostom Blog Categories Widget', 'hostom-addon'),
            array('description' => __('A custom widget for displaying Categories.', 'hostom-addon'))
        );
    }

    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
        $category_count = intval($instance['category_count']);
        $taxonomy = !empty($instance['taxonomy']) ? $instance['taxonomy'] : '';

        echo $args['before_widget'];
        if ($title) {
            echo $args['before_title'] . $title . $args['after_title'];
        }
        include  hostom_get_sidebar_template('blog-categories.php');
?>

    <?php
        echo $args['after_widget'];
    }

    public function form($instance)
    {
        $title = !empty($instance['title']) ? $instance['title'] : __('Categories', 'hostom-addon');
        $category_count = !empty($instance['category_count']) ? $instance['category_count'] : 5;
        $taxonomy = !empty($instance['taxonomy']) ? $instance['taxonomy'] : '';

    ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'hostom-addon'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>

        <p>
            <label for="<?php echo $this->get_field_id('category_count'); ?>"><?php _e('Number of Categories:', 'hostom-addon'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('category_count'); ?>" name="<?php echo $this->get_field_name('category_count'); ?>" type="number" value="<?php echo esc_attr($category_count); ?>">
        </p>

        <?php
        // Taxonomy Field
        $taxonomies = get_taxonomies();

        ?>
        <p>
            <label for="<?php echo $this->get_field_id('taxonomy'); ?>"><?php _e('Select Taxonomy:'); ?></label>
            <select class="widefat" id="<?php echo $this->get_field_id('taxonomy'); ?>" name="<?php echo $this->get_field_name('taxonomy'); ?>">
                <?php foreach ($taxonomies as $tax) { ?>
                    <option value="<?php echo esc_attr($tax); ?>" <?php selected($taxonomy, $tax); ?>><?php echo esc_html($tax); ?></option>
                <?php } ?>
            </select>
        </p>
<?php
    }

    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = sanitize_text_field($new_instance['title']);
        $instance['category_count'] = intval($new_instance['category_count']);
        $instance['taxonomy'] = (!empty($new_instance['taxonomy'])) ? strip_tags($new_instance['taxonomy']) : '';
        return $instance;
    }
}
