<?php

namespace Layerdrops\Hostom\Metaboxes;


class Page
{
    function __construct()
    {
        add_action('cmb2_admin_init', [$this, 'page_metabox']);
    }

    function page_metabox()
    {
        $prefix = 'hostom_';

        $general = new_cmb2_box(array(
            'id'           => $prefix . 'page_option',
            'title'        => __('General Options', 'hostom-addon'),
            'object_types' => array('page'),
            'context'      => 'normal',
            'priority'     => 'default',
        ));

        $general->add_field(array(
            'name' => __('Enable Custom Header', 'hostom-addon'),
            'id' => $prefix . 'custom_header_status',
            'type' => 'radio',
            'options' => array(
                'on' => __('On', 'hostom-addon'),
                'off'   => __('Off', 'hostom-addon'),
            ),
        ));


        $general->add_field(array(
            'name' => __('Select Custom Header', 'hostom-addon'),
            'id' => $prefix . 'select_custom_header',
            'type' => 'pw_select',
            'options' => hostom_post_query('header'),
            'attributes' => array(
                'data-conditional-id' => $prefix . 'custom_header_status',
                'data-conditional-value' => 'on',
            ),
        ));

        $general->add_field(array(
            'name' => __('Enable Custom Footer', 'hostom-addon'),
            'id' => $prefix . 'custom_footer_status',
            'type' => 'radio',
            'options' => array(
                'on' => __('On', 'hostom-addon'),
                'off'   => __('Off', 'hostom-addon'),
            ),
        ));


        $general->add_field(array(
            'name' => __('Select Custom Footer', 'hostom-addon'),
            'id' => $prefix . 'select_custom_footer',
            'type' => 'pw_select',
            'options' => hostom_post_query('footer'),
            'attributes' => array(
                'data-conditional-id' => $prefix . 'custom_footer_status',
                'data-conditional-value' => 'on',
            ),
        ));


        $general->add_field(array(
            'name' => __('Show Page Banner', 'hostom-addon'),
            'id' => $prefix . 'show_page_banner',
            'type' => 'radio',
            'default' => 'on',
            'options' => array(
                'on' => __('On', 'hostom-addon'),
                'off' => __('Off', 'hostom-addon'),
            ),
        ));

        $general->add_field(array(
            'name' => __('Enable BreadCrumb', 'hostom-addon'),
            'id' => $prefix . 'show_page_breadcrumb',
            'type' => 'radio',
            'default' => 'on',
            'options' => array(
                'on' => __('On', 'hostom-addon'),
                'off' => __('Off', 'hostom-addon'),
            ),
            'attributes' => array(
                'data-conditional-id' => $prefix . 'show_page_banner',
                'data-conditional-value' => 'on',
            ),
        ));


        $general->add_field(array(
            'name' => __('Header Title', 'hostom-addon'),
            'id' => $prefix . 'set_header_title',
            'type' => 'text',
            'attributes' => array(
                'data-conditional-id' => $prefix . 'show_page_banner',
                'data-conditional-value' => 'on',
            ),
        ));

        $general->add_field(array(
            'name' => __('Header Image', 'hostom-addon'),
            'id' => $prefix . 'set_header_image',
            'type' => 'file',
            'attributes' => array(
                'data-conditional-id' => $prefix . 'show_page_banner',
                'data-conditional-value' => 'on',
            ),
        ));



        $general->add_field(array(
            'name' => __('Enable RTL Mode', 'hostom-addon'),
            'id' => $prefix . 'enable_rtl_mode',
            'type' => 'radio',
            'default' => 'no',
            'options' => array(
                'yes' => __('On', 'hostom-addon'),
                'no' => __('Off', 'hostom-addon'),
            ),
        ));

        $general->add_field(array(
            'name' => __('Enable Boxed Layout', 'hostom-addon'),
            'id' => $prefix . 'enable_boxed_mode',
            'type' => 'radio',
            'default' => 'no',
            'options' => array(
                'yes' => __('On', 'hostom-addon'),
                'no' => __('Off', 'hostom-addon'),
            ),
        ));

        $general->add_field(array(
            'name' => __('Enable Dark Mode', 'hostom-addon'),
            'id'   => $prefix . 'enable_dark_mode',
            'type' => 'checkbox',
        ));


        $color_options = new_cmb2_box(array(
            'id'           => $prefix . 'page_color_option',
            'title'        => __('Color Options', 'hostom-addon'),
            'object_types' => array('page'),
            'context'      => 'normal',
            'priority'     => 'default',
        ));

        hostom_source_color_meta('set', $color_options);
    }
}
