<?php

namespace Layerdrops\Hostom;

class Customizer
{
    public function __construct()
    {
        add_action("customize_register", [$this, 'hostom_customizer']);
    }
    public function hostom_customizer($wp_customize)
    {

        // add panel
        $wp_customize->add_panel(
            'hostom_theme_opt',
            array(
                'title'      => esc_html__('Hostom Options', 'hostom-addon'),
                'description' => esc_html__('Hostom Theme options panel', 'hostom-addon'),
                'priority'   => 220,
                'capability' => 'edit_theme_options',
            )
        );

        // General Settings
        $wp_customize->add_section('hostom_theme_general', array(
            'title' => __('General Settings', 'hostom-addon'),
            'description' => esc_html__('Hostom General Settings.', 'hostom-addon'),
            'priority' => 10,
            'capability' => 'edit_theme_options',
            'panel'      => 'hostom_theme_opt'
        ));

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Dark Mode?', 'hostom-addon'),
            'hostom_theme_general',
            'hostom_dark_mode',
            'no',
            array(
                'yes' => esc_html__('Yes', 'hostom-addon'),
                'no' => esc_html__('No', 'hostom-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Boxed Mode?', 'hostom-addon'),
            'hostom_theme_general',
            'hostom_boxed_mode',
            'no',
            array(
                'yes' => esc_html__('Yes', 'hostom-addon'),
                'no' => esc_html__('No', 'hostom-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Rtl Mode?', 'hostom-addon'),
            'hostom_theme_general',
            'hostom_rtl_mode',
            'no',
            array(
                'yes' => esc_html__('Yes', 'hostom-addon'),
                'no' => esc_html__('No', 'hostom-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Custom Cursor', 'hostom-addon'),
            'hostom_theme_general',
            'custom_cursor',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'hostom-addon'),
                'no' => esc_html__('No', 'hostom-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Back to top?', 'hostom-addon'),
            'hostom_theme_general',
            'scroll_to_top',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'hostom-addon'),
                'no' => esc_html__('No', 'hostom-addon'),
            )
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Select Back to top text', 'hostom-addon'),
            'hostom_theme_general',
            'scroll_to_top_text',
            'back to top',
            function () {
                return (get_theme_mod('scroll_to_top', 'no') == 'yes' ? true : false);
            }
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Preloader?', 'hostom-addon'),
            'hostom_theme_general',
            'preloader',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'hostom-addon'),
                'no' => esc_html__('No', 'hostom-addon'),
            )
        );

        $this->customize_type_image(
            $wp_customize,
            esc_html__('Custom Preloader Image', 'hostom-addon'),
            'hostom_theme_general',
            'preloader_image',
            '',
            function () {
                return (get_theme_mod('preloader', 'no') == 'yes' ? true : false);
            }
        );

        $this->customize_type_image(
            $wp_customize,
            esc_html__('Page Header Image', 'hostom-addon'),
            'hostom_theme_general',
            'page_header_bg_image'
        );


        // Color Settings
        $wp_customize->add_section('hostom_theme_color', array(
            'title' => __('Color Settings', 'hostom-addon'),
            'description' => esc_html__('Hostom Color Settings.', 'hostom-addon'),
            'priority' => 10,
            'capability' => 'edit_theme_options',
            'panel'      => 'hostom_theme_opt'
        ));

        hostom_source_color_meta('set_customizer', $wp_customize, $this);

        // Blog Layout
        $wp_customize->add_section('hostom_blog_layout_settings', array(
            'title' => __('Blog Layout', 'hostom-addon'),
            'description' => esc_html__('Hostom Blog Layout', 'hostom-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'hostom_theme_opt'
        ));

        $this->customize_type_select(
            $wp_customize,
            'Select Sidebar position',
            'hostom_blog_layout_settings',
            'hostom_blog_layout',
            'right-align',
            array(
                'left-align' => esc_html__('Left Align', 'hostom-addon'),
                'right-align' => esc_html__('Right Align', 'hostom-addon'),
                'full-width' => esc_html__('Full Width', 'hostom-addon'),
            )
        );

        // Shop Layout
        $wp_customize->add_section('hostom_shop_layout_settings', array(
            'title' => __('Shop Layout', 'hostom-addon'),
            'description' => esc_html__('hostom Shop Layout', 'hostom-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'hostom_theme_opt'
        ));


        $this->customize_type_select(
            $wp_customize,
            'Select Shop Column',
            'hostom_shop_layout_settings',
            'hostom_shop_column',
            '3',
            array(
                '2' => esc_html__('2 Column', 'hostom-addon'),
                '3' => esc_html__('3 Column', 'hostom-addon'),
                '4' => esc_html__('4 Column', 'hostom-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            'Select Shop Sidebar position',
            'hostom_shop_layout_settings',
            'hostom_shop_layout',
            'left-align',
            array(
                'left-align' => esc_html__('Left Align', 'hostom-addon'),
                'right-align' => esc_html__('Right Align', 'hostom-addon'),
                'full-width' => esc_html__('Full Width', 'hostom-addon'),
            )
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Shop Product Per page', 'hostom-addon'),
            'hostom_shop_layout_settings',
            'product_per_page',
            esc_html(12)
        );

        // Header options
        $wp_customize->add_section('hostom_theme_header', array(
            'title' => __('Header Settings', 'hostom-addon'),
            'description' => esc_html__('Hostom Header Settings', 'hostom-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'hostom_theme_opt'
        ));

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Add Logo size in px', 'hostom-addon'),
            'hostom_theme_header',
            'header_logo_width',
            esc_html(198)
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__('Enable Sticky Header?', 'hostom-addon'),
            'hostom_theme_header',
            'header_sticky_menu',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'hostom-addon'),
                'no' => esc_html__('No', 'hostom-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Breadcrumb?', 'hostom-addon'),
            'hostom_theme_header',
            'breadcrumb_opt',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'hostom-addon'),
                'no' => esc_html__('No', 'hostom-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__('Enable Custom Header?', 'hostom-addon'),
            'hostom_theme_header',
            'header_custom',
            'no',
            array(
                'yes' => esc_html__('Yes', 'hostom-addon'),
                'no' => esc_html__('No', 'hostom-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            esc_html__('Select Header Type', 'hostom-addon'),
            'hostom_theme_header',
            'header_custom_post',
            '',
            hostom_post_query('header'),
            function () {
                return (get_theme_mod('header_custom', 'no') == 'yes' ? true : false);
            }
        );

        //  Mobile Menu
        $wp_customize->add_section('hostom_theme_mobile_menu', array(
            'title' => esc_html__('Mobile Menu Settings', 'hostom-addon'),
            'description' => esc_html__('Hostom Header Settings', 'hostom-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'hostom_theme_opt'
        ));

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Mobile Menu Email', 'hostom-addon'),
            'hostom_theme_mobile_menu',
            'hostom_mobile_menu_email',
            esc_html__('needhelp@hostom.com', 'hostom-addon')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Mobile Menu Phone', 'hostom-addon'),
            'hostom_theme_mobile_menu',
            'hostom_mobile_menu_phone',
            esc_html__('666 888 0000', 'hostom-addon')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Facebook url', 'hostom-addon'),
            'hostom_theme_mobile_menu',
            'facebook_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Twitter url', 'hostom-addon'),
            'hostom_theme_mobile_menu',
            'twitter_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Linkedin url', 'hostom-addon'),
            'hostom_theme_mobile_menu',
            'linkedin_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Pinterest url', 'hostom-addon'),
            'hostom_theme_mobile_menu',
            'pinterest_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Youtube url', 'hostom-addon'),
            'hostom_theme_mobile_menu',
            'youtube_url',
        );


        $this->customize_type_text(
            $wp_customize,
            esc_html__('dribbble url', 'hostom-addon'),
            'hostom_theme_mobile_menu',
            'dribble_url',
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Instagram url', 'hostom-addon'),
            'hostom_theme_mobile_menu',
            'instagram_url',
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Reddit url', 'hostom-addon'),
            'hostom_theme_mobile_menu',
            'reddit_url',
        );

        // Footer options
        $wp_customize->add_section('hostom_theme_footer', array(
            'title' => esc_html__('Footer Settings', 'hostom-addon'),
            'description' => esc_html__('Hostom Footer Settings.', 'hostom-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'hostom_theme_opt'
        ));

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Footer Text', 'hostom-addon'),
            'hostom_theme_footer',
            'footer_copytext',
            esc_html__('&copy; All right reserved', 'hostom'),
            function () {
                return (get_theme_mod('footer_custom', 'no') == 'yes' ? false : true);
            }
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__('Enable Custom Footer ?', 'hostom-addon'),
            'hostom_theme_footer',
            'footer_custom',
            'no',
            array(
                'yes' => esc_html__('Yes', 'hostom-addon'),
                'no' => esc_html__('No', 'hostom-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            esc_html__('Select Footer Type', 'hostom-addon'),
            'hostom_theme_footer',
            'footer_custom_post',
            '',
            hostom_post_query('footer'),
            function () {
                return (get_theme_mod('footer_custom', 'no') == 'yes' ? true : false);
            }
        );

        // register
        $wp_customize->add_section('hostom_login_settings', array(
            'title' => __('Login/Register Settings', 'hostom-addon'),
            'description' => esc_html__('Login/Register Settings', 'hostom-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'hostom_theme_opt'
        ));

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Redirect url After Login', 'hostom-addon'),
            'hostom_login_settings',
            'login_redirect_url',
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Redirect url After Registration', 'hostom-addon'),
            'hostom_login_settings',
            'registration_redirect_url',
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Redirect url After Log Out', 'hostom-addon'),
            'hostom_login_settings',
            'logout_redirect_url',
        );

        // error page
        $wp_customize->add_section('hostom_error_page_settings', array(
            'title' => __('404 Settings', 'hostom-addon'),
            'description' => esc_html__('Change 404 Text', 'hostom-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'hostom_theme_opt'
        ));

        $this->customize_type_radio(
            $wp_customize,
            esc_html__('Enable Custom 404 ?', 'hostom-addon'),
            'hostom_error_page_settings',
            'error_custom',
            'no',
            array(
                'yes' => esc_html__('Yes', 'hostom-addon'),
                'no' => esc_html__('No', 'hostom-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            esc_html__('Select 404 Page', 'hostom-addon'),
            'hostom_error_page_settings',
            'error_custom_post',
            '',
            hostom_post_query('page'),
            function () {
                return (get_theme_mod('error_custom', 'no') == 'yes' ? true : false);
            }
        );
    }

    //type text
    public function customize_type_text($wp_customize, $label, $section_id, $name,  $default = "", $callback = null)
    {
        // add settings
        $wp_customize->add_setting($name, array(
            'default'  => $default,
            'type'     => 'theme_mod'
        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "text",
                "active_callback" => $callback,
            )
        ));
    }

    //type color
    public function customize_type_color($wp_customize, $section_id, $name,  $default = false)
    {
        $prefix_name = str_replace("-", "_", $name);
        // add settings
        $wp_customize->add_setting($prefix_name, array(
            'default'  => sanitize_hex_color($default),
            'type'     => 'theme_mod'
        ));

        // Add control
        $wp_customize->add_control(new \WP_Customize_Color_Control($wp_customize, $prefix_name, array(
            'label'    => ucwords(str_replace("-", " ", $name)),
            'section'  => $section_id,
            'setting' => $prefix_name,
            'priority' => 1
        )));
    }

    // type checkbox
    public function customize_type_checkbox($wp_customize, $label, $section_id, $name,  $default, $callback = null)
    {
        $wp_customize->add_setting($name, array(
            "default" => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "checkbox",
                "active_callback" => $callback,
            )
        ));
    }

    // type Image
    public function customize_type_image($wp_customize, $label, $section_id, $name,  $default = '', $callback = null)
    {
        $wp_customize->add_setting($name, array(
            "default" => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Upload_Control($wp_customize, $name, array(
            'label'    => $label,
            'section'  => $section_id,
            'setting' => $name,
            'priority' => 20,
            "active_callback" => $callback,
        )));
    }

    public function customize_type_select($wp_customize, $label, $section_id, $name,  $default, $select_value,  $callback = null)
    {
        $wp_customize->add_setting($name, array(
            'default'     => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "select",
                'choices'     => $select_value,
                "active_callback" => $callback,
            )
        ));
    }

    public function customize_type_radio($wp_customize, $label, $section_id, $name,  $default, $radio_value, $callback = null)
    {
        $wp_customize->add_setting($name, array(
            'default'     => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "radio",
                'choices'     => $radio_value,
                "active_callback" => $callback,
            )
        ));
    }
}
