<?php

namespace Layerdrops\Hostom;

class Assets
{

    /**
     * Class constructor
     */
    function __construct()
    {
        add_action('wp_enqueue_scripts', [$this, 'register_assets'], 991);
        add_action('admin_enqueue_scripts', [$this, 'register_assets']);
    }

    /**
     * All available scripts
     *
     * @return array
     */
    public function get_scripts()
    {
        return [
            'bootstrap-select' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/bootstrap-select/js/bootstrap-select.min.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/bootstrap-select/js/bootstrap-select.min.js'),
                'deps'    => ['jquery', 'bootstrap']
            ],
            'jquery-bxslider' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/bxslider/jquery.bxslider.min.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/bxslider/jquery.bxslider.min.js'),
                'deps'    => ['jquery']
            ],
            'countdown' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/countdown/countdown.min.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/countdown/countdown.min.js'),
                'deps'    => ['jquery']
            ],
            'jarallax' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/jarallax/jarallax.min.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/jarallax/jarallax.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-ajaxchimp' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/jquery-ajaxchimp/jquery.ajaxchimp.min.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/jquery-ajaxchimp/jquery.ajaxchimp.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-appear' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/jquery-appear/jquery.appear.min.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/jquery-appear/jquery.appear.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-circle-progress' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/jquery-circle-progress/jquery.circle-progress.min.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/jquery-circle-progress/jquery.circle-progress.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-magnific-popup' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/jquery-magnific-popup/jquery.magnific-popup.min.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/jquery-magnific-popup/jquery.magnific-popup.min.js'),
                'deps'    => ['jquery']
            ],
            'odometer' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/odometer/odometer.min.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/odometer/odometer.min.js'),
                'deps'    => ['jquery']
            ],
            'owl-carousel' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/owl-carousel/owl.carousel.min.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/owl-carousel/owl.carousel.min.js'),
                'deps'    => ['jquery']
            ],
            'swiper' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/swiper/swiper.min.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/swiper/swiper.min.js'),
                'deps'    => ['jquery']
            ],
            'slick-slider' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/slick/slick.min.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/slick/slick.min.js'),
                'deps'    => ['jquery']
            ],
            'wow' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/wow/wow.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/wow/wow.js'),
                'deps'    => ['jquery']
            ],

            'sharer' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/sharer/sharer.min.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/sharer/sharer.min.js'),
                'deps'    => ['jquery']
            ],

            'circletype' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/circleType/jquery.circleType.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/circleType/jquery.circleType.js'),
                'deps'    => ['jquery']
            ],

            'circleletter' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/circleType/jquery.lettering.min.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/circleType/jquery.lettering.min.js'),
                'deps'    => ['jquery']
            ],
            'select2' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/select2/js/select2.min.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/select2/js/select2.min.js'),
                'deps'    => ['jquery']
            ],
            'timepicker' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/timepicker/timePicker.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/timepicker/timePicker.js'),
                'deps'    => ['jquery']
            ],
            'hostom-addon-customizer' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/js/hostom-addon-customizer.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/js/hostom-addon-customizer.js'),
                'deps'    => ['jquery', 'select2']
            ],
            'hostom-addon-script' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/js/hostom-addon.js',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/js/hostom-addon.js'),
                'deps'    => ['jquery']
            ]
        ];
    }

    /**
     * All available styles
     *
     * @return array
     */
    public function get_styles()
    {
        return [
            'animate' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/animate/animate.min.css',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/animate/animate.min.css')
            ],
            'custom-animate' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/animate/custom-animate.css',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/animate/custom-animate.css')
            ],
            'bootstrap-select' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/bootstrap-select/css/bootstrap-select.min.css',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/bootstrap-select/css/bootstrap-select.min.css')
            ],
            'bxslider' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/bxslider/jquery.bxslider.css',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/bxslider/jquery.bxslider.css')
            ],
            'jarallax' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/jarallax/jarallax.css',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/jarallax/jarallax.css')
            ],
            'jquery-magnific-popup' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/jquery-magnific-popup/jquery.magnific-popup.css',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/jquery-magnific-popup/jquery.magnific-popup.css')
            ],
            'odometer' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/odometer/odometer.min.css',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/odometer/odometer.min.css')
            ],
            'owl-carousel' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/owl-carousel/owl.carousel.min.css',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/owl-carousel/owl.carousel.min.css')
            ],
            'owl-theme' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/owl-carousel/owl.theme.default.min.css',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/owl-carousel/owl.theme.default.min.css')
            ],
            'slick' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/slick/slick.css',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/slick/slick.css')
            ],
            'reey-font' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/reey-font/stylesheet.css',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/reey-font/stylesheet.css')
            ],
            'alagambe-font' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/alagambe-font/stylesheet.css',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/alagambe-font/stylesheet.css')
            ],
            'swiper' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/swiper/swiper.min.css',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/swiper/swiper.min.css')
            ],
            'select2' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/select2/css/select2.min.css',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/select2/css/select2.min.css')
            ],
            'jquery-ui' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/jquery-ui/jquery-ui.css',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/jquery-ui/jquery-ui.css')
            ],
            'timepicker' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/vendors/timepicker/timePicker.css',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/vendors/timepicker/timePicker.css')
            ],
            'hostom-addon-style' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/css/hostom-addon.css',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/css/hostom-addon.css')
            ],
            'hostom-addon-admin-style' => [
                'src'     => HOSTOM_ADDON_ASSETS . '/css/hostom-addon-admin.css',
                'version' => filemtime(HOSTOM_ADDON_PATH . '/assets/css/hostom-addon-admin.css')
            ]
        ];
    }

    /**
     * Register scripts and styles
     *
     * @return void
     */
    public function register_assets()
    {
        $scripts = $this->get_scripts();
        $styles  = $this->get_styles();

        foreach ($scripts as $handle => $script) {
            $deps = isset($script['deps']) ? $script['deps'] : false;

            wp_register_script($handle, $script['src'], $deps, $script['version'], true);
        }

        foreach ($styles as $handle => $style) {
            $deps = isset($style['deps']) ? $style['deps'] : false;

            wp_register_style($handle, $style['src'], $deps, $style['version']);
        }
    }
}
