<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!-- Video Style One Start-->
    <section class="video-one">
        <div class="video-one__bg jarallax" data-jarallax data-speed="0.3" data-imgPosition="50% -100%" style="background-image: url(<?php echo esc_url($settings['layout_one_bg_image']['url']); ?>);"></div>
        <!-- /.video-one__bg -->
        <div class="container">
            <div class="video-one__btn">
                <?php if (!empty($settings['layout_one_video_url']['url'])) : ?>
                    <a href="<?php echo esc_url($settings['layout_one_video_url']['url']); ?>" class="video-popup">
                        <i class="fa fa-play"></i>
                    </a>
                <?php endif; ?>
                <div class="curved-circle">
                    <!-- curved-circle start-->
                    <div class="curved-circle--item" data-circle-text-options='{
					"radius": 92,
					"forceWidth": true,
					"forceHeight": true
				}'>
                        <?php echo wp_kses($settings['rounded_text'], 'hostom_allowed_tags'); ?>
                    </div>
                </div><!-- curved-circle end-->
            </div><!-- /.video-one__btn -->
            <?php
            if (!empty($settings['title'])) :
                $this->add_inline_editing_attributes('title', 'none');
                hostom_elementor_rendered_content($this, 'title', 'video-one__title', $settings['title_tag_layout_one']);
            endif;
            ?>
            <?php if (!empty($settings['layout_one_button_url']['url'])) : ?>
                <a href="<?php echo esc_url($settings['layout_one_button_url']['url']); ?>" <?php esc_attr(!empty($settings['layout_one_button_url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn video-one__link">
                    <span><?php echo wp_kses($settings['layout_one_button_label'], 'hostom_allowed_tags'); ?></span>
                </a>
            <?php endif; ?>
        </div><!-- /.container -->
    </section><!-- /.video-one -->

    <!-- Video Style One End -->
<?php endif; ?>