<?php if ('layout_two' === $settings['layout_type']) : ?>
    <section class="testimonials-three">
        <?php if (!empty($settings['layout_two_bg']['url'])) : ?>
            <div class="testimonials-three__bg" style="background-image: url(<?php echo esc_url($settings['layout_two_bg']['url']); ?>);"></div><!-- / -->
        <?php endif; ?>
        <div class="row">
            <div class="col-lg-5">
                <div class="testimonials-three__left">
                    <div class="testimonials-three__top">
                        <div class="sec-title text-start wow fadeInUp" data-wow-duration='700ms'>
                            <?php
                            if (!empty($settings['layout_two_sec_sub_title'])) :
                                $this->add_inline_editing_attributes('layout_two_sec_sub_title', 'none');
                                hostom_elementor_rendered_content($this, 'layout_two_sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_two']);
                            endif;

                            if (!empty($settings['layout_two_sec_title'])) :
                                $this->add_inline_editing_attributes('layout_two_sec_title', 'none');
                                hostom_elementor_rendered_content($this, 'layout_two_sec_title', 'sec-title__title', $settings['section_title_tag_layout_two']);
                            endif;
                            ?>
                        </div><!-- /.sec-title -->
                        <?php
                        if (!empty($settings['layout_two_sec_summary'])) :
                            $this->add_inline_editing_attributes('layout_two_sec_summary', 'none');
                            hostom_elementor_rendered_content($this, 'layout_two_sec_summary', 'testimonials-three__text', 'p');
                        endif;
                        ?>
                    </div><!-- /.testimonials-three__top -->
                </div><!-- /.testimonials-three__left -->
            </div><!-- /.col-lg-5 -->
            <div class="col-lg-7">
                <div class="testimonials-three__right">
                    <div class="testimonials-three__carousel hostom-owl__carousel hostom-owl__carousel--with-shadow owl-carousel" data-owl-options='<?php echo esc_attr(hostom_get_owl_options($settings)); ?>'>
                        <?php foreach ($settings['layout_two_testimonials'] as $index => $item) :  ?>
                            <div class="item">
                                <div class="testimonials-three__card">
                                    <div class="testimonials-three__card__author">
                                        <div class="testimonials-three__card__author__image">
                                            <?php hostom_elementor_rendered_image($item, 'image'); ?>
                                        </div><!-- /.testimonials-one__content__author__image -->
                                        <div class="testimonials-three__card__author__content">
                                            <<?php echo esc_attr($item['testimonial_name_tag_layout_two']); ?> class="testimonials-three__card__author__content__name">
                                                <?php echo wp_kses($item['name'], 'hostom_allowed_tags'); ?>
                                            </<?php echo esc_attr($item['testimonial_name_tag_layout_two']); ?>><!-- /.testimonials-three__card__content__name -->
                                            <span class="testimonials-three__card__author__content__deg"><?php echo wp_kses($item['designation'], 'hostom_allowed_tags'); ?></span><!-- /.testimonials-three__card__content__deg -->
                                        </div><!-- /.testimonials-three__card__content -->
                                    </div><!-- /.testimonials-one__content__author -->
                                    <div class="testimonials-three__card__content">
                                        <h3 class="testimonials-three__card__title"><?php echo wp_kses($item['title'], 'hostom_allowed_tags'); ?></h3><!-- /.testimonials-three__card__title -->
                                        <p class="testimonials-three__card__text"><?php echo wp_kses($item['testimonial'], 'hostom_allowed_tags'); ?></p><!-- /.testimonials-three__card__text -->
                                    </div><!-- /.testimonials-three__card__content -->
                                    <div class="testimonials-three__card__rating">
                                        <?php for ($i = 0; $i < $item['rating']['size']; $i++) : ?>
                                            <i class="icon-star"></i>
                                        <?php endfor; ?>
                                    </div><!-- /.testimonials-three__card__rating -->
                                    <div class="testimonials-three__card__quite">
                                        <?php hostom_elementor_rendered_image($item, 'quite'); ?>
                                    </div><!-- / -->
                                </div><!-- /.testimonials-three__card -->
                            </div><!-- /.item -->
                        <?php endforeach; ?>
                    </div>
                </div><!-- /.testimonial-three__left -->
            </div><!-- /.col-lg-8 -->
        </div><!-- /.row -->
    </section><!-- /.testimonials-three -->
<?php endif; ?>