<?php if ('layout_three' === $settings['layout_type']) : ?>

    <!-- service-three section end -->
    <section class="testimonial-three">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="sec-title text-start wow fadeInUp" data-wow-duration='700ms'>
                        <?php
                        if (!empty($settings['layout_three_sec_sub_title'])) :
                            $this->add_inline_editing_attributes('layout_three_sec_sub_title', 'none');
                            hostom_elementor_rendered_content($this, 'layout_three_sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_three']);
                        endif;

                        if (!empty($settings['layout_three_sec_title'])) :
                            $this->add_inline_editing_attributes('layout_three_sec_title', 'none');
                            hostom_elementor_rendered_content($this, 'layout_three_sec_title', 'sec-title__title', $settings['section_title_tag_layout_three']);
                        endif;
                        ?>
                    </div><!-- /.sec-title -->
                </div>
            </div>
            <div class="row gutter-y-30">
                <div class="col-lg-3 col-md-12">
                    <div class="testimonial-three__carousel-thumb hostom-owl__carousel owl-carousel owl-theme" data-owl-options='{
					"items": 3,
					"margin": 1,
					"smartSpeed": 700,
					"loop":false,
					"autoplay": false,
					"URLhashListener":true,
					"center": true,
					"nav":false,
					"dots":false,
					"responsive": {
						"0": {
							"items": 1
						},
						"500": {
							"items": 1
						}
					}
				}'>
                        <?php
                        $j = 1;
                        foreach ($settings['layout_three_testimonial'] as $index => $item) :  ?>
                            <a href="#item<?php echo esc_attr($j); ?>" class="item" data-hash="item<?php echo esc_attr($j); ?>">
                                <span class="testimonial-three__meta-thumb">
                                    <?php hostom_elementor_rendered_image($item, 'image_two'); ?>
                                </span>
                            </a><!-- testimonial-author -->
                        <?php $j++;
                        endforeach; ?>
                    </div>
                </div>
                <div class="col-lg-9 col-md-12">
                    <div class="testimonial-three__carousel hostom-owl__carousel owl-carousel owl-theme" data-owl-options='{
					"items": 1,
					"margin": 0,
					"smartSpeed": 700,
					"loop":true,
					"autoplay": false,
					"nav":true,
					"URLhashListener":true,
					"dots":false,
					"navText": ["<span class=\"icon-left-arrow\"></span>","<span class=\"icon-right-arrow\"></span>"],
					"responsive": {
						"0": {
							"items": 1
						},
						"500": {
							"items": 1
						}
					}
					}'>
                        <?php
                        $j = 1;
                        foreach ($settings['layout_three_testimonial'] as $index => $item) :  ?>
                            <div class="testimonial-three__item" data-hash="item<?php echo esc_attr($j); ?>">
                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="testimonial-three__thumb">
                                            <?php hostom_elementor_rendered_image($item, 'image'); ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-8">
                                        <div class="testimonial-three__content">
                                            <div class="testimonial-three__rating">
                                                <?php for ($i = 0; $i < $item['rating']['size']; $i++) : ?>
                                                    <i class="icon-star"></i>
                                                <?php endfor; ?>
                                            </div>
                                            <p class="testimonial-three__text"><?php echo wp_kses($item['testimonial'], 'hostom_allowed_tags'); ?></p>
                                            <div class="testimonial-three__author">
                                                <<?php echo esc_attr($item['testimonial_name_tag_layout_three']); ?> class="testimonial-three__author__name">
                                                    <?php echo wp_kses($item['name'], 'hostom_allowed_tags'); ?>
                                                </<?php echo esc_attr($item['testimonial_name_tag_layout_three']); ?>>
                                                <span class="testimonial-three__author__deg"><?php echo wp_kses($item['designation'], 'hostom_allowed_tags'); ?></span>
                                            </div>
                                            <div class="testimonial-three__quite">
                                                <?php hostom_elementor_rendered_image($item, 'quite'); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php $j++;
                        endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="testimonial-three__shape testimonial-three__shape--one">
            <?php hostom_elementor_rendered_image($settings, 'layout_three_shape_one'); ?>
        </div>
        <div class="testimonial-three__shape testimonial-three__shape--two">
            <?php hostom_elementor_rendered_image($settings, 'layout_three_shape_two'); ?>
        </div>
    </section>
    <!-- service-three section end -->
<?php endif; ?>