<?php if ('layout_six' === $settings['layout_type']) : ?>
    <!--Testimonial Two Start-->
    <section class="testimonials-one">
        <div class="container">
            <?php if (!empty($settings['layout_six_sec_sub_title'] || $settings['layout_six_sec_title'])) : ?>
                <div class="sec-title">
                    <?php hostom_elementor_rendered_image($settings, 'layout_six_title_image', 'sec-title__img'); ?>
                    <?php
                    if (!empty($settings['layout_six_sec_sub_title'])) :
                        $this->add_inline_editing_attributes('layout_six_sec_sub_title', 'none');
                        hostom_elementor_rendered_content($this, 'layout_six_sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_six']);
                    endif;

                    if (!empty($settings['layout_six_sec_title'])) :
                        $this->add_inline_editing_attributes('layout_six_sec_title', 'none');
                        hostom_elementor_rendered_content($this, 'layout_six_sec_title', 'sec-title__title', $settings['section_title_tag_layout_six']);
                    endif;
                    ?>
                </div><!-- /.sec-title -->
            <?php endif; ?>
            <div class="testimonials-one__carousel hostom-owl__carousel hostom-owl__carousel--with-shadow hostom-owl__carousel--basic-nav owl-carousel owl-theme" data-owl-options='<?php echo esc_attr(hostom_get_owl_options($settings)); ?>'>
                <?php foreach ($settings['layout_six_testimonials'] as $index => $item) :  ?>
                    <div class="item">
                        <div class="testimonials-card wow fadeInUp" data-wow-duration='1500ms' data-wow-delay='000ms'>
                            <div class="testimonials-card__inner" style="background-image: url(<?php echo esc_url($item['shape']['url']); ?>);">
                                <div class="testimonials-card__top">
                                    <div class="testimonials-card__image">
                                        <?php hostom_elementor_rendered_image($item, 'image'); ?>
                                    </div><!-- /.testimonials-card__image -->
                                    <div class="testimonials-card__top__left">
                                        <div class="testimonials-card__rating">
                                            <?php for ($i = 0; $i < $item['rating']['size']; $i++) : ?>
                                                <i class="fa fa-star"></i>
                                            <?php endfor; ?>
                                        </div><!-- /.testimonials-card__rating -->
                                        <<?php echo esc_attr($item['testimonial_name_tag_layout_six']); ?> class="testimonials-card__name">
                                            <?php echo wp_kses($item['name'], 'hostom_allowed_tags'); ?>
                                        </<?php echo esc_attr($item['testimonial_name_tag_layout_six']); ?>><!-- /.testimonials-card__name -->
                                        <p class="testimonials-card__designation"><?php echo wp_kses($item['designation'], 'hostom_allowed_tags'); ?></p><!-- /.testimonials-card__designation -->
                                    </div><!-- /.testimonials-card__top__left -->
                                </div><!-- /.testimonials-card__top -->
                                <div class="testimonials-card__content">
                                    <?php echo wp_kses($item['testimonial'], 'hostom_allowed_tags'); ?>
                                </div><!-- /.testimonials-card__content -->
                            </div><!-- /.testimonials-card__inner -->
                        </div><!-- /.testimonials-card -->
                    </div><!-- /.item -->
                <?php endforeach; ?>
            </div><!-- /.testimonials-one__carousel -->

        </div><!-- /.container -->
    </section><!-- /.testimonials-one -->
    <!--Testimonial Two End-->
<?php endif; ?>