<?php if ('layout_one' === $settings['layout_type']) : ?>

    <section class="testimonial-two">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="sec-title text-center wow fadeInUp" data-wow-duration='700ms'>
                        <?php
                        if (!empty($settings['sec_sub_title'])) :
                            $this->add_inline_editing_attributes('sec_sub_title', 'none');
                            hostom_elementor_rendered_content($this, 'sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_one']);
                        endif;

                        if (!empty($settings['sec_title'])) :
                            $this->add_inline_editing_attributes('sec_title', 'none');
                            hostom_elementor_rendered_content($this, 'sec_title', 'sec-title__title', $settings['section_title_tag_layout_one']);
                        endif;
                        ?>
                    </div><!-- /.sec-title -->
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="testimonial-two__carousel hostom-owl__carousel owl-carousel owl-theme" data-owl-options='{
					"items": 1,
					"margin": 0,
					"smartSpeed": 700,
					"loop":true,
					"autoplay": false,
					"nav":true,
					"URLhashListener":true,
					"dots":false,
					"navText": ["<span class=\"icon-left-arrow\"></span>","<span class=\"icon-right-arrow\"></span>"],
					"responsive": {
						"0": {
							"items": 1
						},
						"500": {
							"items": 1
						}
					}
				}'>
                        <?php
                        $i = 1;
                        foreach ($settings['testimonials'] as $index => $item) :  ?>
                            <div class="item" data-hash="item<?php echo esc_attr($i); ?>">
                                <div class="testimonial-two__item">
                                    <div class="testimonial-two__thumb">
                                        <?php hostom_elementor_rendered_image($item, 'image'); ?>
                                        <div class="testimonial-two__thumb__author">
                                            <<?php echo esc_attr($item['testimonial_name_tag_layout_one']); ?> class="testimonial-two__thumb__name"><?php echo wp_kses($item['name'], 'hostom_allowed_tags'); ?></<?php echo esc_attr($item['testimonial_name_tag_layout_one']); ?>>
                                            <span class="testimonial-two__thumb__deg"><?php echo wp_kses($item['designation'], 'hostom_allowed_tags'); ?></span>
                                        </div>
                                    </div>
                                    <div class="testimonial-two__content">
                                        <div class="testimonial-two__rating">
                                            <?php for ($k = 0; $k < $item['rating']['size']; $k++) : ?>
                                                <i class="icon-star"></i>
                                            <?php endfor; ?>
                                        </div>
                                        <h4 class="testimonial-two__title"><?php echo wp_kses($item['title'], 'hostom_allowed_tags'); ?></h4>
                                        <p class="testimonial-two__text"><?php echo wp_kses($item['testimonial'], 'hostom_allowed_tags'); ?></p>
                                        <div class="testimonial-two__quite">
                                            <?php \Elementor\Icons_Manager::render_icon($item['quote_icon'], ['aria-hidden' => 'true'], 'i'); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php $i++;
                        endforeach; ?>
                    </div>
                    <div class="carousel-thumb__two">
                        <!-- Testimonial Thumb -->
                        <div class="testimonial-two__carousel-thumb hostom-owl__carousel owl-carousel owl-theme" data-owl-options='{
							"items": 5,
							"margin": 1,
							"smartSpeed": 700,
							"loop":true,
							"autoplay": false,
							"URLhashListener":true,
							"center": true,
							"dots":false,
							"responsive": {
								"0": {
									"items": 3
								},
								"500": {
									"items": 3
								}
							}
						}'>
                            <?php
                            $j = 1;
                            foreach ($settings['testimonials'] as $index => $item) :  ?>
                                <a href="#item<?php echo esc_attr($j); ?>" class="item" data-hash="item<?php echo esc_attr($j); ?>">
                                    <span class="testimonial-two__meta-thumb"><?php hostom_elementor_rendered_image($item, 'image'); ?></span>
                                </a><!-- testimonial-author -->
                            <?php $j++;
                            endforeach; ?>
                        </div>
                        <!-- Testimonial Thumb -->
                    </div><!-- / -->
                </div>
            </div>
        </div>
    </section>

<?php endif; ?>