<?php if ('layout_four' === $settings['layout_type']) : ?>

    <section class="testimonial-fore">
        <div class="testimonial-fore__bg" style="background-image: url(<?php echo esc_url($settings['layout_four_bg_image']['url']); ?>);"></div>
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="sec-title sec-title--two text-center wow fadeInUp" data-wow-duration='700ms'>
                        <?php
                        if (!empty($settings['layout_four_sec_sub_title'])) :
                            $this->add_inline_editing_attributes('layout_four_sec_sub_title', 'none');
                            hostom_elementor_rendered_content($this, 'layout_four_sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_four']);
                        endif;

                        if (!empty($settings['layout_four_sec_title'])) :
                            $this->add_inline_editing_attributes('layout_four_sec_title', 'none');
                            hostom_elementor_rendered_content($this, 'layout_four_sec_title', 'sec-title__title', $settings['section_title_tag_layout_four']);
                        endif;
                        ?>
                    </div><!-- /.sec-title -->
                </div>
            </div>
            <div class="testimonial-fore__inner">
                <div class="testimonial-fore__inner__bg" style="background-image: url(<?php echo esc_url($settings['layout_four_bg_image']['url']); ?>);"></div>
                <div class="row">
                    <div class="col-12">
                        <div class="testimonial-fore__carousel hostom-slick__carousel" data-slick-options='{
                        "slidesToShow": 2,
                        "slidesToScroll": 1,
                        "vertical": true,
                        "asNavFor": ".testimonial-fore__image",
                        "autoplay": true,
                        "dots": true,
                        "centerPadding": 20,
                        "centerMode": true,
                        "arrows": false
                        }'>
                            <?php foreach ($settings['layout_four_testimonials'] as $item) : ?>
                                <div class="item">
                                    <div class="testimonial-fore__item">
                                        <div class="testimonial-fore__item__author">
                                            <div class="testimonial-fore__item__author__thumb">
                                                <?php hostom_elementor_rendered_image($item, 'image'); ?>
                                            </div>
                                            <div class="testimonial-fore__item__author__content">
                                                <<?php echo esc_attr($item['testimonial_name_tag_layout_four']); ?> class="testimonial-fore__item__author__name">
                                                    <?php echo wp_kses($item['name'], 'hostom_allowed_tags'); ?>
                                                </<?php echo esc_attr($item['testimonial_name_tag_layout_four']); ?>>
                                                <span class="testimonial-fore__item__author__deg"><?php echo wp_kses($item['designation'], 'hostom_allowed_tags'); ?></span>
                                            </div>
                                        </div>
                                        <h4 class="testimonial-fore__item__title"><?php echo wp_kses($item['title'], 'hostom_allowed_tags'); ?></h4>
                                        <p class="testimonial-fore__item__text"><?php echo wp_kses($item['testimonial'], 'hostom_allowed_tags'); ?></p>
                                        <div class="testimonial-fore__item__rating">
                                            <?php for ($i = 0; $i < $item['rating']['size']; $i++) : ?>
                                                <i class="icon-star"></i>
                                            <?php endfor; ?>
                                        </div>
                                        <div class="testimonial-fore__item__quite">
                                            <?php hostom_elementor_rendered_image($item, 'quite'); ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <ul class="testimonial-fore__image hostom-slick__carousel" data-slick-options='{
                        "slidesToShow": 3,
                        "slidesToScroll": 1,
                        "autoplay": true,
                        "vertical": true,
                        "centerMode": true,
                        "asNavFor": ".testimonial-fore__carousel",
                        "focusOnSelect": true,
                        "dots": false,
                        "centerPadding": 0,
                        "arrows": false,
                        "responsive": [
                            {
                                "breakpoint": 767,
                                "settings": {
                                    "vertical": false
                                }
                            }
                        ]
                        }'>
                            <?php foreach ($settings['layout_four_testimonials'] as $item) : ?>
                                <!-- Testimonial Item -->
                                <li role="presentation">
                                    <div class="testimonial-fore__image__item">
                                        <?php hostom_elementor_rendered_image($item, 'image'); ?>
                                    </div>
                                </li>
                                <!-- Testimonial Item -->
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php endif; ?>