<?php if ('layout_five' === $settings['layout_type']) : ?>

    <!-- Testimonials Five -->
    <section class="testimonials-three" style="background-image: url(<?php echo esc_url($settings['layout_five_bg_shape']['url']); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-xl-4">
                    <div class="testimonials-three__content">
                        <div class="sec-title">
                            <?php hostom_elementor_rendered_image($settings, 'layout_five_title_image', 'sec-title__img'); ?>
                            <?php
                            if (!empty($settings['layout_five_sec_sub_title'])) :
                                $this->add_inline_editing_attributes('layout_five_sec_sub_title', 'none');
                                hostom_elementor_rendered_content($this, 'layout_five_sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_five']);
                            endif;

                            if (!empty($settings['layout_five_sec_title'])) :
                                $this->add_inline_editing_attributes('layout_five_sec_title', 'none');
                                hostom_elementor_rendered_content($this, 'layout_five_sec_title', 'sec-title__title', $settings['section_sub_title_tag_layout_five']);
                            endif;
                            ?>
                        </div><!-- /.sec-title -->
                        <?php
                        if (!empty($settings['layout_five_sec_summary'])) :
                            $this->add_inline_editing_attributes('layout_five_sec_summary', 'none');
                            hostom_elementor_rendered_content($this, 'layout_five_sec_summary', 'testimonials-three__content__text', 'p');
                        endif;
                        ?>
                        <div class="testimonials-three__carousel-nav">
                            <a href="#" class="testimonial-three__prev"><span class="icon-left-arrow"></span></a>
                            <a href="#" class="testimonial-three__next"><span class="icon-right-arrow"></span></a>
                        </div>
                    </div>
                </div>
                <div class="col-xl-8">
                    <div class="testimonials-three__carousel hostom-owl__carousel hostom-owl__carousel--with-shadow owl-theme owl-carousel hostom-owl__carousel--custom-nav" data-owl-nav-prev=".testimonial-three__prev" data-owl-nav-next=".testimonial-three__next" data-owl-options='<?php echo esc_attr(hostom_get_owl_options_two($settings)); ?>'>
                        <?php foreach ($settings['layout_five_testimonial'] as $index => $item) :  ?>
                            <div class="item">
                                <div class="testimonials-three__item">
                                    <div class="testimonials-three__item__content" style="background-image: url(<?php echo esc_url($item['shape_two']['url']); ?>);">
                                        <div class="testimonials-three__meta">
                                            <<?php echo esc_attr($item['testimonial_name_tag_layout_five']); ?> class="testimonials-three__meta__title">
                                                <?php echo wp_kses($item['name'], 'hostom_allowed_tags'); ?>
                                            </<?php echo esc_attr($item['testimonial_name_tag_layout_five']); ?>>
                                            <span class="testimonials-three__meta__designation">
                                                <?php echo wp_kses($item['designation'], 'hostom_allowed_tags'); ?>
                                            </span>
                                        </div>
                                        <div class="testimonials-three__ratings">
                                            <?php for ($i = 0; $i < $item['rating']['size']; $i++) : ?>
                                                <span class="fa fa-star"></span>
                                            <?php endfor; ?>
                                        </div>
                                        <div class="testimonials-three__quote">
                                            <?php echo wp_kses($item['testimonial'], 'hostom_allowed_tags'); ?>
                                        </div>
                                    </div>
                                    <div class="testimonials-three__item__thumb">
                                        <div class="testimonials-three__item__thumb-one">
                                            <?php hostom_elementor_rendered_image($item, 'image_one'); ?>
                                        </div>
                                        <div class="testimonials-three__item__thumb-two">
                                            <?php hostom_elementor_rendered_image($item, 'image_two'); ?>
                                        </div>
                                        <div class="testimonials-three__item__thumb-flower">
                                            <?php hostom_elementor_rendered_image($item, 'shape_one'); ?>
                                        </div>
                                    </div>
                                </div>
                            </div><!-- /.testimonials-item -->
                        <?php endforeach; ?>
                    </div>
                </div>
            </div><!-- /.container -->
        </div>
    </section>
    <!-- testimonials-Five -->

<?php endif; ?>