<?php if ('layout_three' == $settings['layout_type']) : ?>
	<section class="team-details">
		<div class="container">
			<div class="team-details__inner">
				<div class="row">
					<div class="col-md-5">
						<div class="team-details__image  wow fadeInLeft" data-wow-delay='500ms'>
							<?php hostom_elementor_rendered_image($settings, 'layout_three_image'); ?>
						</div><!-- /.team-details__image -->
					</div><!-- /.col-lg-6 -->

					<div class="col-md-7">
						<div class="team-details__content">
							<h6 class="team-details__content__subtitle  wow fadeInUp" data-wow-delay='500ms'><?php echo wp_kses($settings['layout_three_sec_sub_title'], 'hostom_allowed_tags'); ?></h6>
							<h3 class="team-details__content__title  wow fadeInUp" data-wow-delay='500ms'><?php echo wp_kses($settings['layout_three_sec_title'], 'hostom_allowed_tags'); ?></h3><!-- /.team-details__title -->
							<p class="team-details__content__text  wow fadeInUp" data-wow-delay='500ms'><?php echo wp_kses($settings['layout_three_summary'], 'hostom_allowed_tags'); ?></p><!-- /.team-details__content__text -->
							<!-- /.team-details__designation -->
							<div class="team-details__content__highlight  wow fadeInUp" data-wow-delay='500ms'>
								<span class="team-details__content__highlight__text"><?php echo wp_kses($settings['layout_three_highlighted_text'], 'hostom_allowed_tags'); ?></span>
							</div><!-- /.team-details__content__highlight -->
							<ul class="list-unstyled team-details__list  wow fadeInUp ml-0" data-wow-delay='500ms'>
								<?php echo wp_kses($settings['layout_three_features'], 'hostom_allowed_tags'); ?>
							</ul><!-- /.list-unstyled team-details__list -->

							<div class="team-skills">
								<?php
								foreach ($settings['layout_three_porogressbar_list'] as $index => $item) : ?>
									<div class="team-skills__progress">
										<h4 class="team-skills__progress__title"><?php echo esc_html($item['title']); ?></h4>
										<div class="team-skills__progress__bar">
											<div class="team-skills__progress__inner count-bar" data-percent="<?php echo esc_attr($item['count']['size']); ?>%">
												<div class="team-skills__progress__number count-text"><?php echo esc_html($item['count']['size']); ?>%</div>
											</div>
										</div>
									</div><!-- /.skills-item -->
								<?php endforeach; ?>
							</div><!-- /team-skills-one -->

							<div class="team-details__social  wow fadeInUp" data-wow-delay='500ms'>
								<?php foreach ($settings['layout_three_social_icons'] as $social_icon) : ?>
									<a <?php echo esc_attr(!empty($social_icon['social_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($social_icon['social_url']['url']); ?>">
										<?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true'], 'i'); ?>
									</a>
								<?php endforeach; ?>
							</div><!-- /.team-details__social -->

						</div><!-- /.team-details__content -->
					</div><!-- /.col-lg-6 -->
				</div><!-- /.row -->
			</div><!-- /.team-details__inner -->
		</div><!-- /.container -->
	</section><!-- /.team-details -->
<?php endif; ?>