<?php if ('layout_one' == $settings['layout_type']) : ?>
	<section class="team-one team-one--page">
		<div class="container">
			<div class="row gutter-y-30">
				<?php
				foreach ($settings['team_items'] as $item) : ?>
					<div class="col-md-6 col-lg-4">
						<div class="team-card wow fadeInUp" data-wow-duration='1500ms' data-wow-delay='000ms'>
							<div class="team-card__inner">
								<a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?> class="team-card__image">
									<?php hostom_elementor_rendered_image($item, 'image'); ?>
								</a><!-- /.team-card__image -->
								<div class="team-card__content">
									<<?php echo esc_attr($item['team_name_tag_layout_one']); ?> class="team-card__content__title">
										<a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?>>
											<?php echo wp_kses($item['name'], 'hostom_allowed_tags'); ?>
										</a>
									</<?php echo esc_attr($item['team_name_tag_layout_one']); ?>><!-- /.team-card__title -->
									<h6 class="team-card__content__designation"><?php echo wp_kses($item['designation'], 'hostom_allowed_tags'); ?></h6><!-- /.team-card__designation -->
									<div class="team-card__content__hover">
										<div class="team-card__content__hover__icon">
											<i class="icon-share"></i>
										</div><!-- /.team-card__content__hover__icon -->
										<div class="team-card__content__hover__social">
											<?php echo wp_kses($item['social_network'], 'hostom_allowed_tags'); ?>
										</div><!-- /.team-card__social__list -->
									</div><!-- /.team-card__content__hover -->
								</div><!-- /.team-card__content -->
							</div><!-- /.team-card__content -->
						</div><!-- /.team-card -->
					</div><!-- /.col-md-6 col-lg-4 -->
				<?php endforeach; ?>
			</div><!-- /.row -->
		</div><!-- /.container -->
	</section><!-- /.team-one -->
<?php endif; ?>