<?php if ('layout_four' == $settings['layout_type']) : ?>
	<!-- Team Style four Start -->
	<section class="team-one">
		<div class="container">
			<div class="sec-title">
				<?php hostom_elementor_rendered_image($settings, 'layout_four_title_image', 'sec-title__img'); ?>
				<?php
				if (!empty($settings['layout_four_sec_sub_title'])) :
					$this->add_inline_editing_attributes('layout_four_sec_sub_title', 'none');
					hostom_elementor_rendered_content($this, 'layout_four_sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_four']);
				endif;

				if (!empty($settings['layout_four_sec_title'])) :
					$this->add_inline_editing_attributes('layout_four_sec_title', 'none');
					hostom_elementor_rendered_content($this, 'layout_four_sec_title', 'sec-title__title', $settings['section_title_tag_layout_four']);
				endif;
				?>
			</div><!-- /.sec-title -->
			<div class="team-one__carousel hostom-owl__carousel hostom-owl__carousel--with-shadow hostom-owl__carousel--basic-nav owl-carousel owl-theme" data-owl-options='<?php echo esc_attr(hostom_get_owl_options($settings)); ?>'>
				<?php
				foreach ($settings['layout_four_team_items'] as $item) : ?>
					<div class="item">
						<div class="team-card wow fadeInUp" data-wow-duration='1500ms' data-wow-delay='000ms'>
							<div class="team-card__image">
								<div class="team-card__image__bg"></div><!-- /.team-card__image__bg -->
								<?php hostom_elementor_rendered_image($item, 'image'); ?>
								<div class="team-card__hover">
									<div class="team-card__social">
										<i class="fa fa-share-alt"></i>
										<div class="list-unstyled team-card__social__list">
											<?php echo wp_kses($item['social_network'], 'hostom_allowed_tags'); ?>
										</div><!-- /.list-unstyled team-card__social__list -->
									</div><!-- /.team-card__social -->
									<?php if (!empty($item['mail'])) : ?>
										<div class="team-card__email">
											<?php echo wp_kses($item['mail'], 'hostom_allowed_tags'); ?>
										</div><!-- /.team-card__email -->
									<?php endif; ?>
								</div><!-- /.team-card__hover -->
							</div><!-- /.team-card__image -->
							<div class="team-card__content">
								<<?php echo esc_attr($item['team_designation_tag_layout_four']); ?> class="team-card__designation">
									<?php echo wp_kses($item['designation'], 'hostom_allowed_tags'); ?>
								</<?php echo esc_attr($item['team_designation_tag_layout_four']); ?>><!-- /.team-card__designation -->
								<<?php echo esc_attr($item['team_name_tag_layout_four']); ?> class="team-card__title">
									<a href="<?php echo esc_url($item['url']['url']); ?>"><?php echo wp_kses($item['name'], 'hostom_allowed_tags'); ?></a>
								</<?php echo esc_attr($item['team_name_tag_layout_four']); ?>><!-- /.team-card__title -->
							</div><!-- /.team-card__content -->
						</div><!-- /.team-card -->
					</div><!-- /.item -->
				<?php
				endforeach; ?>
			</div><!-- /.row -->
		</div><!-- /.container -->
	</section><!-- /.team-one -->
	<!-- Team Style One End -->
<?php endif; ?>