<?php if ('layout_five' == $settings['layout_type']) : ?>
	<!-- Team Start -->
	<section class="team-one team-one-about">
		<div class="container">
			<div class="hostom-owl__dots hostom-owl__carousel owl-with-shadow owl-theme owl-carousel" data-owl-options='<?php echo esc_attr(hostom_get_owl_options($settings)); ?>'>
				<?php
				$counter = 1;
				foreach ($settings['layout_five_team_items'] as $item) : ?>
					<div class="item">
						<div class="team-one__item">
							<div class="team-one__item__image">
								<?php hostom_elementor_rendered_image($item, 'image'); ?>
							</div><!-- /.team-image -->
							<div class="team-one__item__content">
								<<?php echo esc_attr($item['team_name_tag_layout_five']); ?> class="team-one__item__title">
									<?php
									if (!empty($item['name'])) :
										hostom_basic_rendered_content($this, $item,  'name', '', 'a');
									endif;
									?>
								</<?php echo esc_attr($item['team_name_tag_layout_five']); ?>><!-- /.team-name -->
								<?php
								if (!empty($item['designation'])) :
									hostom_basic_rendered_content($this, $item,  'designation', 'team-one__item__designation', 'span');
								endif;
								?>
								<div class="team-one__item__social-wrapper">
									<a class="team-one__item__links" href="#"><span class="fas fa-share-alt"></span></a><!-- /.social-more -->
									<div class="team-one__item__social">
										<?php echo wp_kses($item['social_network'], 'hostom_allowed_tags'); ?>
									</div><!-- /.team-social -->
								</div>
							</div><!-- /.team-content -->
						</div><!-- /.team-one -->
					</div>
				<?php $counter++;
				endforeach; ?>
			</div>
		</div>
	</section>
	<!-- Team Start -->
<?php endif; ?>